"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewResponse = exports.RulePreviewRequestQuery = exports.RulePreviewRequestBody = exports.RulePreviewParams = exports.RulePreviewLogs = exports.RulePreviewLoggedRequest = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_schemas = require("../model/rule_schema/rule_schemas.gen");
var _primitives = require("../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Rule preview API endpoint
 *   version: 2023-10-31
 */

const RulePreviewParams = exports.RulePreviewParams = _zod.z.object({
  invocationCount: _zod.z.number().int(),
  timeframeEnd: _zod.z.string().datetime()
});
const RulePreviewLoggedRequest = exports.RulePreviewLoggedRequest = _zod.z.object({
  request: _primitives.NonEmptyString.optional(),
  description: _primitives.NonEmptyString.optional(),
  duration: _zod.z.number().int().optional(),
  request_type: _primitives.NonEmptyString.optional()
});
const RulePreviewLogs = exports.RulePreviewLogs = _zod.z.object({
  errors: _zod.z.array(_primitives.NonEmptyString),
  warnings: _zod.z.array(_primitives.NonEmptyString),
  /**
   * Execution duration in milliseconds
   */
  duration: _zod.z.number().int(),
  startedAt: _primitives.NonEmptyString.optional(),
  requests: _zod.z.array(RulePreviewLoggedRequest).optional()
});
const RulePreviewRequestQuery = exports.RulePreviewRequestQuery = _zod.z.object({
  /**
   * Enables logging and returning in response ES queries, performed during rule execution
   */
  enable_logged_requests: _zodHelpers.BooleanFromString.optional()
});
const RulePreviewRequestBody = exports.RulePreviewRequestBody = _zod.z.discriminatedUnion('type', [_rule_schemas.EqlRuleCreateProps.merge(RulePreviewParams), _rule_schemas.QueryRuleCreateProps.merge(RulePreviewParams), _rule_schemas.SavedQueryRuleCreateProps.merge(RulePreviewParams), _rule_schemas.ThresholdRuleCreateProps.merge(RulePreviewParams), _rule_schemas.ThreatMatchRuleCreateProps.merge(RulePreviewParams), _rule_schemas.MachineLearningRuleCreateProps.merge(RulePreviewParams), _rule_schemas.NewTermsRuleCreateProps.merge(RulePreviewParams), _rule_schemas.EsqlRuleCreateProps.merge(RulePreviewParams)]);
const RulePreviewResponse = exports.RulePreviewResponse = _zod.z.object({
  logs: _zod.z.array(RulePreviewLogs),
  previewId: _primitives.NonEmptyString.optional(),
  isAborted: _zod.z.boolean().optional()
});