"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksImages = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _links = require("../links");
var _beta_badge = require("./beta_badge");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_images.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const noop = () => {};
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    link: (0, _react2.css)`
      color: inherit;
      &:hover {
        text-decoration: none;
      }
    `,
    image: (0, _react2.css)`
      align-items: center;
      overflow: hidden;
      width: ${(0, _eui.mathWithUnits)(euiTheme.size.xxxl, x => x * 5)};
      height: ${(0, _eui.mathWithUnits)(euiTheme.size.xxxl, x => x * 3)};
      border-radius: ${euiTheme.border.radius.medium};

      img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
      }
    `,
    content: (0, _react2.css)`
      padding-left: ${euiTheme.size.s};
    `,
    titleContainer: (0, _react2.css)`
      display: flex;
      align-items: center;
    `,
    title: (0, _react2.css)`
      color: ${euiTheme.colors.primaryText};
      align-items: center;
    `,
    description: (0, _react2.css)`
      padding-top: ${euiTheme.size.xs};
      max-width: 550px;
    `
  };
};
const LandingLinksImages = exports.LandingLinksImages = /*#__PURE__*/_react.default.memo(function LandingLinksImages({
  items,
  urlState,
  onLinkClick
}) {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, items.map(item => {
    const linkProps = (0, _utils.getKibanaLinkProps)({
      item,
      urlState,
      onLinkClick
    });
    const {
      id,
      title,
      description,
      landingImage,
      isBeta,
      betaOptions
    } = item;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      "data-test-subj": "LandingItem",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, (0, _extends2.default)({}, linkProps, {
      css: styles.link,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      element: "div",
      hasBorder: true,
      hasShadow: false,
      paddingSize: "m",
      onClick: noop,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.image,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 21
      }
    }, landingImage && /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      "data-test-subj": "LandingLinksImage",
      size: "l",
      role: "presentation",
      alt: "",
      src: landingImage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.content,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: styles.titleContainer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      css: styles.title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 27
      }
    }, title)), isBeta && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 36
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: styles.description,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 23
      }
    }, description))))));
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksImages;