"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDisableUsers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/edit_user/confirm_disable_users.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmDisableUsers = ({
  usernames,
  onCancel,
  onSuccess
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services
  } = (0, _public.useKibana)();
  const isSystemUser = usernames[0] === 'kibana' || usernames[0] === 'kibana_system';
  const [state, disableUsers] = (0, _useAsyncFn.default)(async () => {
    for (const username of usernames) {
      try {
        await new _.UserAPIClient(services.http).disableUser(username);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.successMessage', {
          defaultMessage: "Deactivated user ''{username}''",
          values: {
            username
          }
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        services.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.errorMessage', {
            defaultMessage: "Could not deactivate user ''{username}''",
            values: {
              username
            }
          }),
          text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
        });
      }
    }
  }, [services.http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    role: "dialog",
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.title', {
      defaultMessage: "Deactivate {count, plural, one{user ''{username}''} other{{count} users}}?",
      values: {
        count: usernames.length,
        username: usernames[0]
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onCancel,
    onConfirm: disableUsers,
    cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: isSystemUser ? _i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.confirmSystemPasswordButton', {
      defaultMessage: '{isLoading, select, true{Deactivating user…} other{I understand, deactivate this user}}',
      values: {
        isLoading: state.loading
      }
    }) : _i18n.i18n.translate('xpack.security.management.users.confirmDisableUsers.confirmButton', {
      defaultMessage: '{isLoading, select, true{Deactivating {count, plural, one{user} other{users}}…} other{Deactivate {count, plural, one{user} other{users}}}}',
      values: {
        count: usernames.length,
        isLoading: state.loading
      }
    }),
    buttonColor: isSystemUser ? 'danger' : undefined,
    isLoading: state.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, isSystemUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDisableUsers.systemUserWarning",
    defaultMessage: "Deactivating this user will prevent Kibana from communicating with Elasticsearch.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDisableUsers.systemUserDescription",
    defaultMessage: "Once deactivated, you must manually update your config file with different user details and restart Kibana.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDisableUsers.description",
    defaultMessage: "{count, plural, one{This user} other{These users}} will no longer be able to access Elastic{count, plural, one{.} other{:}}",
    values: {
      count: usernames.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  })), usernames.length > 1 && /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, usernames.map(username => /*#__PURE__*/_react.default.createElement("li", {
    key: username,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, username)))));
};
exports.ConfirmDisableUsers = ConfirmDisableUsers;