"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSummaryTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _securityUiComponents = require("@kbn/security-ui-components");
var _privilege_summary_calculator = require("./privilege_summary_calculator");
var _privilege_summary_expanded_row = require("./privilege_summary_expanded_row");
var _space_column_header = require("./space_column_header");
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/privilege_summary/privilege_summary_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getColumnKey(entry) {
  return `privilege_entry_${entry.spaces.join('|')}`;
}
function showPrivilege({
  allSpacesSelected,
  primaryFeature,
  globalPrimaryFeature
}) {
  if ((primaryFeature === null || primaryFeature === void 0 ? void 0 : primaryFeature.name) == null || primaryFeature !== null && primaryFeature !== void 0 && primaryFeature.disabled || primaryFeature !== null && primaryFeature !== void 0 && primaryFeature.requireAllSpaces && !allSpacesSelected) {
    return 'None';
  }

  // If primary feature requires all spaces we cannot rely on primaryFeature.name.
  // Example:
  // primaryFeature: feature with requireAllSpaces in space-a has all privileges set to All
  // globalPrimaryFeature: feature in *AllSpaces has privileges set to Read (this is the correct one to display)
  if (primaryFeature !== null && primaryFeature !== void 0 && primaryFeature.requireAllSpaces && allSpacesSelected) {
    var _globalPrimaryFeature;
    return (_globalPrimaryFeature = globalPrimaryFeature === null || globalPrimaryFeature === void 0 ? void 0 : globalPrimaryFeature.name) !== null && _globalPrimaryFeature !== void 0 ? _globalPrimaryFeature : 'None';
  }
  return primaryFeature === null || primaryFeature === void 0 ? void 0 : primaryFeature.name;
}
const PrivilegeSummaryTable = props => {
  const [expandedFeatures, setExpandedFeatures] = (0, _react.useState)([]);
  const featureCategories = (0, _react.useMemo)(() => {
    const featureCategoryMap = new Map();
    props.kibanaPrivileges.getSecuredFeatures().filter(feature => feature.privileges != null || feature.reserved != null).forEach(feature => {
      if (!featureCategoryMap.has(feature.category.id)) {
        featureCategoryMap.set(feature.category.id, []);
      }
      featureCategoryMap.get(feature.category.id).push(feature);
    });
    return featureCategoryMap;
  }, [props.kibanaPrivileges]);
  const calculator = new _privilege_summary_calculator.PrivilegeSummaryCalculator(props.kibanaPrivileges, props.role);
  const toggleExpandedFeature = featureId => {
    if (expandedFeatures.includes(featureId)) {
      setExpandedFeatures(expandedFeatures.filter(ef => ef !== featureId));
    } else {
      setExpandedFeatures([...expandedFeatures, featureId]);
    }
  };
  const featureColumn = {
    name: 'Feature',
    field: 'feature',
    render: feature => {
      return /*#__PURE__*/_react.default.createElement(_securityUiComponents.FeatureTableCell, {
        feature: feature,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 14
        }
      });
    }
  };
  const rowExpanderColumn = {
    align: 'right',
    width: '40px',
    isExpander: true,
    field: 'featureId',
    name: '',
    render: (featureId, record) => {
      const feature = record.feature;
      const hasSubFeaturePrivileges = feature.getSubFeaturePrivileges().length > 0;
      if (!hasSubFeaturePrivileges) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleExpandedFeature(featureId),
        "data-test-subj": `expandPrivilegeSummaryRow`,
        "aria-label": expandedFeatures.includes(featureId) ? 'Collapse' : 'Expand',
        iconType: expandedFeatures.includes(featureId) ? 'arrowUp' : 'arrowDown',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 9
        }
      });
    }
  };
  const rawKibanaPrivileges = [...props.role.kibana].sort((entry1, entry2) => {
    if ((0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(entry1)) {
      return -1;
    }
    if ((0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(entry2)) {
      return 1;
    }
    return 0;
  });
  const globalRawPrivilege = rawKibanaPrivileges.find(entry => (0, _securityRoleManagementModel.isGlobalPrivilegeDefinition)(entry));
  const globalPrivilege = globalRawPrivilege ? calculator.getEffectiveFeaturePrivileges(globalRawPrivilege) : null;
  const privilegeColumns = rawKibanaPrivileges.map(entry => {
    const key = getColumnKey(entry);
    return {
      name: /*#__PURE__*/_react.default.createElement(_space_column_header.SpaceColumnHeader, {
        entry: entry,
        spaces: props.spaces,
        spacesApiUi: props.spacesApiUi,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 9
        }
      }),
      field: key,
      render: (kibanaPrivilege, record) => {
        var _globalPrivilege$reco;
        const {
          primary,
          hasCustomizedSubFeaturePrivileges
        } = kibanaPrivilege[record.featureId];
        let iconTip = null;
        if (hasCustomizedSubFeaturePrivileges) {
          iconTip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            size: "s",
            type: "info",
            content: /*#__PURE__*/_react.default.createElement("span", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 172,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.privilegeSummary.additionalPrivilegesGrantedIconTip",
              defaultMessage: "Additional privileges granted. Expand this row for more information.",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 173,
                columnNumber: 19
              }
            })),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 168,
              columnNumber: 13
            }
          });
        } else {
          iconTip = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "s",
            type: "empty",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 182,
              columnNumber: 21
            }
          });
        }
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": `privilegeColumn ${hasCustomizedSubFeaturePrivileges ? 'additionalPrivilegesGranted' : ''}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 185,
            columnNumber: 11
          }
        }, showPrivilege({
          allSpacesSelected: props.spaces.some(space => space.id === _constants.ALL_SPACES_ID),
          primaryFeature: primary,
          globalPrimaryFeature: globalPrivilege === null || globalPrivilege === void 0 ? void 0 : (_globalPrivilege$reco = globalPrivilege[record.featureId]) === null || _globalPrivilege$reco === void 0 ? void 0 : _globalPrivilege$reco.primary
        }), ' ', iconTip);
      }
    };
  });
  const columns = [];
  if (props.canCustomizeSubFeaturePrivileges) {
    columns.push(rowExpanderColumn);
  }
  columns.push(featureColumn, ...privilegeColumns);
  const privileges = rawKibanaPrivileges.reduce((acc, entry) => {
    return {
      ...acc,
      [getColumnKey(entry)]: [entry.spaces, calculator.getEffectiveFeaturePrivileges(entry)]
    };
  }, {});
  const accordions = [];
  featureCategories.forEach(featuresInCategory => {
    const {
      category
    } = featuresInCategory[0];
    const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": `featureCategoryButton_${category.id}`,
      alignItems: 'center',
      responsive: false,
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 7
      }
    }, category.euiIconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: category.euiIconType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      className: "eui-displayInlineBlock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    }, category.label))));
    const categoryPrivileges = Object.fromEntries(Object.entries(privileges).map(([key, [, featurePrivileges]]) => [key, featurePrivileges]));
    const categoryItems = featuresInCategory.map(feature => {
      return {
        feature,
        featureId: feature.id,
        ...categoryPrivileges
      };
    });
    accordions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `privilegeSummaryFeatureCategory_${category.id}`,
      "data-test-subj": `privilegeSummaryFeatureCategory_${category.id}`,
      key: category.id,
      buttonContent: buttonContent,
      initialIsOpen: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      columns: columns,
      items: categoryItems,
      itemId: "featureId",
      rowProps: record => {
        return {
          'data-test-subj': `summaryTableRow-${record.featureId}`
        };
      },
      itemIdToExpandedRowMap: expandedFeatures.reduce((acc, featureId) => {
        return {
          ...acc,
          [featureId]: /*#__PURE__*/_react.default.createElement(_privilege_summary_expanded_row.PrivilegeSummaryExpandedRow, {
            feature: props.kibanaPrivileges.getSecuredFeature(featureId),
            effectiveFeaturePrivileges: Object.values(privileges).map(([spaces, privs]) => [spaces, privs[featureId]]),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 275,
              columnNumber: 17
            }
          })
        };
      }, {}),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    })));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordions.map((a, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, a, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }))));
};
exports.PrivilegeSummaryTable = PrivilegeSummaryTable;