"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _add_role_template_button = require("./add_role_template_button");
var _role_template_editor = require("./role_template_editor");
var _model = require("../../../../../common/model");
var _role_combo_box = require("../../../role_combo_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/role_selector/role_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class RoleSelector extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getRoleComboBox", () => {
      const {
        roles = []
      } = this.props.roleMapping;
      return /*#__PURE__*/_react.default.createElement(_role_combo_box.RoleComboBox, {
        "data-test-subj": "roleMappingFormRolesCombo",
        placeholder: _i18n.i18n.translate('xpack.security.management.editRoleMapping.selectRolesPlaceholder', {
          defaultMessage: 'Select one or more roles'
        }),
        isLoading: this.state.roles.length === 0,
        availableRoles: this.state.roles,
        selectedRoleNames: roles,
        onChange: selectedRoles => {
          this.props.onChange({
            ...this.props.roleMapping,
            roles: selectedRoles,
            role_templates: []
          });
        },
        isDisabled: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "getRoleTemplates", () => {
      const {
        role_templates: roleTemplates = []
      } = this.props.roleMapping;
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 7
        }
      }, roleTemplates.map((rt, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_role_template_editor.RoleTemplateEditor, {
        "data-test-subj": "roleMappingFormRoleTemplateEditor",
        canUseStoredScripts: this.props.canUseStoredScripts,
        canUseInlineScripts: this.props.canUseInlineScripts,
        roleTemplate: rt,
        onChange: updatedTemplate => {
          const templates = [...(this.props.roleMapping.role_templates || [])];
          templates.splice(index, 1, updatedTemplate);
          this.props.onChange({
            ...this.props.roleMapping,
            role_templates: templates
          });
        },
        onDelete: () => {
          const templates = [...(this.props.roleMapping.role_templates || [])];
          templates.splice(index, 1);
          this.props.onChange({
            ...this.props.roleMapping,
            role_templates: templates
          });
        },
        readOnly: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 13
        }
      }), index === roleTemplates.length - 1 && this.props.readOnly ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }))), this.conditionallyRenderAddRoleTemplateButton());
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderAddRoleTemplateButton", () => {
      if (!this.props.readOnly) {
        return /*#__PURE__*/_react.default.createElement(_add_role_template_button.AddRoleTemplateButton, {
          canUseStoredScripts: this.props.canUseStoredScripts,
          canUseInlineScripts: this.props.canUseInlineScripts,
          onClick: type => {
            switch (type) {
              case 'inline':
                {
                  const templates = this.props.roleMapping.role_templates || [];
                  this.props.onChange({
                    ...this.props.roleMapping,
                    roles: [],
                    role_templates: [...templates, {
                      template: {
                        source: ''
                      }
                    }]
                  });
                  break;
                }
              case 'stored':
                {
                  const templates = this.props.roleMapping.role_templates || [];
                  this.props.onChange({
                    ...this.props.roleMapping,
                    roles: [],
                    role_templates: [...templates, {
                      template: {
                        id: ''
                      }
                    }]
                  });
                  break;
                }
              default:
                throw new Error(`Unsupported template type: ${type}`);
            }
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 9
          }
        });
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "getHelpText", () => {
      if (this.props.mode === 'roles' && this.hasDeprecatedRolesAssigned()) {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "deprecatedRolesAssigned",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 163,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.deprecatedRolesAssigned",
          defaultMessage: "This mapping is assigned a deprecated role. Please migrate to a supported role.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 164,
            columnNumber: 11
          }
        }));
      }
    });
    (0, _defineProperty2.default)(this, "hasDeprecatedRolesAssigned", () => {
      var _this$props$roleMappi, _this$props$roleMappi2;
      return (_this$props$roleMappi = (_this$props$roleMappi2 = this.props.roleMapping.roles) === null || _this$props$roleMappi2 === void 0 ? void 0 : _this$props$roleMappi2.some(r => this.state.roles.some(role => role.name === r && (0, _model.isRoleDeprecated)(role)))) !== null && _this$props$roleMappi !== void 0 ? _this$props$roleMappi : false;
    });
    this.state = {
      roles: []
    };
  }
  async componentDidMount() {
    const roles = await this.props.rolesAPIClient.getRoles();
    this.setState({
      roles
    });
  }
  render() {
    const {
      mode
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      helpText: this.getHelpText(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, mode === 'roles' ? this.getRoleComboBox() : this.getRoleTemplates());
  }
}
exports.RoleSelector = RoleSelector;
(0, _defineProperty2.default)(RoleSelector, "defaultProps", {
  readOnly: false
});