"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiKeysManagementApp = exports.Providers = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _use_current_user = require("../../components/use_current_user");
var _readonly_badge = require("../badges/readonly_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/api_keys/api_keys_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const apiKeysManagementApp = exports.apiKeysManagementApp = Object.freeze({
  id: 'api_keys',
  create({
    authc,
    getStartServices
  }) {
    return {
      id: this.id,
      order: 30,
      title: _i18n.i18n.translate('xpack.security.management.apiKeysTitle', {
        defaultMessage: 'API keys'
      }),
      async mount({
        element,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart], {
          APIKeysGridPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./api_keys_grid/api_keys_grid_page')))]);
        (0, _reactDom.render)(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          history: history,
          authc: authc,
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(coreStart.chrome, setBreadcrumbs),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: _i18n.i18n.translate('xpack.security.management.apiKeysTitle', {
            defaultMessage: 'API keys'
          }),
          href: "/",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(APIKeysGridPage, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 17
          }
        })))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
const Providers = ({
  services,
  history,
  authc,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_use_current_user.AuthenticationProvider, {
  authc: authc,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
  featureId: "api_keys",
  tooltip: _i18n.i18n.translate('xpack.security.management.api_keys.readonlyTooltip', {
    defaultMessage: 'Unable to create or edit API keys'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 9
  }
}, children))));
exports.Providers = Providers;