"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExcludePinDocumentButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_flyout/pin_exclude_document_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExcludePinDocumentButton = ({
  documentCount,
  addNewAction,
  pinType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutButton",
    iconType: "plusInCircle",
    color: documentCount === 0 ? 'primary' : 'text',
    size: "s",
    onClick: addNewAction,
    fill: documentCount === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, pinType === 'pinned' ? documentCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addPinnedDocumentButton",
    defaultMessage: "Pin document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addPinnedDocumentButtonMore",
    defaultMessage: "Pin 1 more document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }) : documentCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addExcludedDocumentButton",
    defaultMessage: "Exclude document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addExcludedDocumentButtonMore",
    defaultMessage: "Exclude 1 more document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }));
};
exports.ExcludePinDocumentButton = ExcludePinDocumentButton;