"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _field_error_utils = require("../../../../utils/field_error_utils");
var _document_selector = require("./document_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_flyout/document_selector/draggable_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DraggableList = ({
  actionFields,
  actionIdsFields,
  pinType,
  isIdRule = false,
  indexNames = [],
  onDeleteDocument,
  onIndexSelectorChange,
  onIdSelectorChange,
  dragEndHandle,
  errors
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: dragEndHandle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "queryRuleDroppable",
    spacing: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionFields.length === 0 && (actionIdsFields === null || actionIdsFields === void 0 ? void 0 : actionIdsFields.length) === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: "At least one document is required",
    color: "warning",
    size: "s",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }), isIdRule && actionIdsFields ? actionIdsFields.map((doc, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    usePortal: true,
    spacing: "m",
    index: index,
    hasInteractiveChildren: true,
    draggableId: 'queryRuleDocumentDraggable-' + doc + '-' + index,
    key: doc + '-' + index,
    isDragDisabled: pinType === 'exclude',
    "data-test-subj": `queryRuleDocumentDraggable-id-${doc}-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 17
    }
  }, () => {
    var _errors$actions, _errors$actions$docs;
    const docError = errors === null || errors === void 0 ? void 0 : (_errors$actions = errors.actions) === null || _errors$actions === void 0 ? void 0 : (_errors$actions$docs = _errors$actions.docs) === null || _errors$actions$docs === void 0 ? void 0 : _errors$actions$docs[index];
    const fieldError = (0, _field_error_utils.isFieldError)(docError) ? docError : undefined;
    return /*#__PURE__*/_react.default.createElement(_document_selector.DocumentSelector, {
      initialDocId: doc,
      indexDoc: index,
      type: pinType,
      hasIndexSelector: false,
      onDeleteDocument: () => {
        onDeleteDocument(index);
      },
      onIdSelectorChange: id => {
        onIdSelectorChange(index, id);
      },
      error: fieldError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 23
      }
    });
  })) : actionFields.map((doc, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    usePortal: true,
    spacing: "m",
    index: index,
    hasInteractiveChildren: true,
    draggableId: 'queryRuleDocumentDraggable-' + doc._id + '-' + index,
    key: doc._id,
    isDragDisabled: pinType === 'exclude',
    "data-test-subj": `queryRuleDocumentDraggable-doc-${doc._id}-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, () => {
    var _errors$actions2, _errors$actions2$docs;
    const docError = errors === null || errors === void 0 ? void 0 : (_errors$actions2 = errors.actions) === null || _errors$actions2 === void 0 ? void 0 : (_errors$actions2$docs = _errors$actions2.docs) === null || _errors$actions2$docs === void 0 ? void 0 : _errors$actions2$docs[index];
    const fieldError = docError !== null && docError !== void 0 && docError.type && docError.message ? docError : undefined;
    return /*#__PURE__*/_react.default.createElement(_document_selector.DocumentSelector, {
      initialDocId: doc._id,
      indexDoc: index,
      type: pinType,
      index: doc._index,
      onDeleteDocument: () => {
        onDeleteDocument(index);
      },
      onIndexSelectorChange: indexName => {
        onIndexSelectorChange(index, indexName);
      },
      onIdSelectorChange: id => {
        onIdSelectorChange(index, id);
      },
      indices: indexNames,
      error: fieldError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 23
      }
    });
  })) || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null))));
};
exports.DraggableList = DraggableList;