"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotebooksList = void 0;
var _react = _interopRequireDefault(require("react"));
var _loading_panel = require("./loading_panel");
var _selection_panel = require("./selection_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_notebooks/public/components/notebooks_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotebooksList = ({
  notebooks,
  onNotebookSelect,
  selectedNotebookId
}) => {
  if (notebooks === null) {
    // Loading Notebooks
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, notebooks.map(notebook => /*#__PURE__*/_react.default.createElement(_selection_panel.SelectionPanel, {
    key: notebook.id,
    id: notebook.id,
    title: notebook.title,
    description: notebook.description,
    onClick: onNotebookSelect,
    isSelected: selectedNotebookId === notebook.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  })));
};
exports.NotebooksList = NotebooksList;