"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStartPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_kibana = require("../../hooks/use_kibana");
var _indices = require("../../utils/indices");
var _use_user_permissions = require("../../hooks/api/use_user_permissions");
var _use_indices_status = require("../../hooks/api/use_indices_status");
var _use_indices_redirect = require("./hooks/use_indices_redirect");
var _elasticsearch_start = require("./elasticsearch_start");
var _load_indices_status_error = require("../shared/load_indices_status_error");
var _use_page_chrome = require("../../hooks/use_page_chrome");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/start/start_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PageTitle = _i18n.i18n.translate('xpack.searchIndices.startPage.docTitle', {
  defaultMessage: 'Create your first index'
});
const ElasticsearchStartPage = () => {
  const {
    console: consolePlugin,
    history,
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  const indexName = (0, _react.useMemo)(() => (0, _indices.generateRandomIndexName)(), []);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(indexName);
  const {
    data: indicesData,
    isInitialLoading,
    isError: hasIndicesStatusFetchError,
    error: indicesFetchError
  } = (0, _use_indices_status.useIndicesStatusQuery)();
  (0, _use_page_chrome.usePageChrome)(PageTitle, [{
    text: PageTitle
  }], false);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  (0, _use_indices_redirect.useIndicesRedirect)(indicesData, userPrivileges);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "elasticsearchStartPage",
    grow: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "top",
    restrictWidth: false,
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 30
    }
  }), hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_load_indices_status_error.LoadIndicesStatusError, {
    error: indicesFetchError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 40
    }
  }), !isInitialLoading && !hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_elasticsearch_start.ElasticsearchStart, {
    indicesData: indicesData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  })), embeddableConsole);
};
exports.ElasticsearchStartPage = ElasticsearchStartPage;