"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countVectorBasedTypesFromMappings = countVectorBasedTypesFromMappings;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function countVectorBasedTypesFromMappings(mappings) {
  const typeCounts = {
    semantic_text: 0,
    dense_vector: 0,
    sparse_vector: 0
  };
  const typeCountKeys = Object.keys(typeCounts);
  function recursiveCount(fields) {
    if (!fields) {
      return;
    }
    if ('mappings' in fields) {
      recursiveCount(fields.mappings);
    }
    if ('properties' in fields && fields.properties) {
      Object.keys(fields.properties).forEach(key => {
        var _fields$properties;
        const value = (_fields$properties = fields.properties) === null || _fields$properties === void 0 ? void 0 : _fields$properties[key];
        if (value && value.type) {
          if (typeCountKeys.includes(value.type)) {
            const type = value.type;
            typeCounts[type] = typeCounts[type] + 1;
          }
          if ('fields' in value) {
            recursiveCount(value.fields);
          }
          if ('properties' in value) {
            recursiveCount(value.properties);
          }
        } else if (value.properties || value.fields) {
          recursiveCount(value);
        }
      });
    }
  }
  recursiveCount(mappings);
  return typeCounts;
}