"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentList = void 0;
var _react = _interopRequireDefault(require("react"));
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _eui = require("@elastic/eui");
var _recent_docs_action_message = require("./recent_docs_action_message");
var _use_delete_document = require("../../hooks/api/use_delete_document");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/index_documents/document_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocumentList = ({
  indexName,
  docs,
  mappingProperties,
  hasDeleteDocumentsPrivilege
}) => {
  const {
    mutate
  } = (0, _use_delete_document.useDeleteDocument)(indexName);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_recent_docs_action_message.RecentDocsActionMessage, {
    indexName: indexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), docs.map(doc => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: doc._id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.Result, {
      fields: (0, _searchIndexDocuments.reorderFieldsInImportance)((0, _searchIndexDocuments.resultToField)(doc, mappingProperties)),
      metaData: (0, _searchIndexDocuments.resultMetaData)(doc),
      onDocumentDelete: () => {
        mutate({
          id: doc._id
        });
      },
      compactCard: false,
      hasDeleteDocumentsPrivilege: hasDeleteDocumentsPrivilege,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    }));
  }));
};
exports.DocumentList = DocumentList;