"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepReview = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _components = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/step_review.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JOB_DETAILS_TABS = [_components.JOB_DETAILS_TAB_SUMMARY, _components.JOB_DETAILS_TAB_TERMS, _components.JOB_DETAILS_TAB_HISTOGRAM, _components.JOB_DETAILS_TAB_METRICS, _components.JOB_DETAILS_TAB_REQUEST];
class StepReview extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "selectTab", tab => {
      this.setState({
        selectedTab: tab
      });
    });
    this.state = {
      selectedTab: JOB_DETAILS_TABS[0]
    };
  }
  renderTabs() {
    const {
      selectedTab
    } = this.state;
    const {
      job
    } = this.props;
    const renderedTabs = [];
    JOB_DETAILS_TABS.forEach((tab, index) => {
      if (tab === _components.JOB_DETAILS_TAB_TERMS && !job.terms.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_HISTOGRAM && !job.histogram.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_METRICS && !job.metrics.length) {
        return;
      }
      const isSelected = tab === selectedTab;
      renderedTabs.push(/*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => this.selectTab(tab),
        isSelected: isSelected,
        "data-test-subj": "stepReviewTab",
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      }, _components.tabToHumanizedMap[tab]));
    });
    if (!renderedTabs.length === 1) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, renderedTabs), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }));
  }
  render() {
    const {
      job
    } = this.props;
    const {
      selectedTab
    } = this.state;
    const json = (0, _services.serializeJob)(job);
    const endpoint = `PUT _rollup/job/${job.id}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateReviewTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepReviewTitle",
      defaultMessage: "Review details for ''{jobId}''",
      values: {
        jobId: job.id
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }))), this.renderTabs(), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.JobDetails, {
      job: job,
      json: json,
      endpoint: endpoint,
      tab: selectedTab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    })));
  }
}
exports.StepReview = StepReview;
(0, _defineProperty2.default)(StepReview, "propTypes", {
  job: _propTypes.default.object.isRequired
});