"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportStatusIndicator = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("@kbn/reporting-common/constants");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_status_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  completed: _i18n.i18n.translate('xpack.reporting.statusIndicator.completedLabel', {
    defaultMessage: 'Done'
  }),
  completedWithWarnings: _i18n.i18n.translate('xpack.reporting.statusIndicator.completedWithWarningsLabel', {
    defaultMessage: 'Done, warnings detected'
  }),
  pending: _i18n.i18n.translate('xpack.reporting.statusIndicator.pendingLabel', {
    defaultMessage: 'Pending'
  }),
  processing: ({
    attempt,
    of
  }) => of !== undefined ? _i18n.i18n.translate('xpack.reporting.statusIndicator.processingMaxAttemptsLabel', {
    defaultMessage: `Processing, attempt {attempt} of {of}`,
    values: {
      attempt,
      of
    }
  }) : _i18n.i18n.translate('xpack.reporting.statusIndicator.processingLabel', {
    defaultMessage: `Processing, attempt {attempt}`,
    values: {
      attempt
    }
  }),
  failed: _i18n.i18n.translate('xpack.reporting.statusIndicator.failedLabel', {
    defaultMessage: 'Failed'
  }),
  unknown: _i18n.i18n.translate('xpack.reporting.statusIndicator.unknownLabel', {
    defaultMessage: 'Unknown'
  }),
  lastStatusUpdate: ({
    date
  }) => _i18n.i18n.translate('xpack.reporting.statusIndicator.lastStatusUpdateLabel', {
    defaultMessage: 'Updated at {date}',
    values: {
      date
    }
  })
};
const ReportStatusIndicator = ({
  job
}) => {
  const hasIssues = (0, _react.useMemo)(() => (0, _utils.jobHasIssues)(job), [job]);
  let icon;
  let statusText;
  switch (job.status) {
    case _constants.JOB_STATUS.COMPLETED:
      if (hasIssues) {
        icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "warning",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 16
          }
        });
        statusText = i18nTexts.completedWithWarnings;
        break;
      }
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "checkInCircleFilled",
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.completed;
      break;
    case _constants.JOB_STATUS.WARNINGS:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.completedWithWarnings;
      break;
    case _constants.JOB_STATUS.PENDING:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.pending;
      break;
    case _constants.JOB_STATUS.PROCESSING:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.processing({
        attempt: job.attempts,
        of: job.max_attempts
      });
      break;
    case _constants.JOB_STATUS.FAILED:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "error",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.failed;
      break;
    default:
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cross",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 14
        }
      });
      statusText = i18nTexts.unknown;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18nTexts.lastStatusUpdate({
      date: job.getPrettyStatusTimestamp()
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    "aria-label": statusText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, statusText)));
};
exports.ReportStatusIndicator = ReportStatusIndicator;