"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectInConsoleButton = void 0;
var _lzString = require("lz-string");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _get_console_text_pit = require("./get_console_text_pit");
var _get_console_text_scroll = require("./get_console_text_scroll");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/inspect_in_console_button/inspect_in_console_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InspectInConsoleButtonUi = props => {
  const {
    csvConfig,
    job,
    searchSourceStart,
    locators
  } = props;
  const {
    title: jobTitle,
    pagingStrategy
  } = job;
  const serializedSearchSource = job.payload.searchSource;
  const handleDevToolsLinkClick = (0, _react.useCallback)(async () => {
    const searchSource = await searchSourceStart.create(serializedSearchSource);
    const index = searchSource.getField('index');
    if (!index) {
      throw new Error(`The search must have a reference to an index pattern!`);
    }
    const indexPatternTitle = index.getIndexPattern();
    const queryUri = (0, _lzString.compressToEncodedURIComponent)(pagingStrategy === 'scroll' ? (0, _get_console_text_scroll.getScrollApiTextForConsole)(jobTitle, indexPatternTitle, searchSource, csvConfig) : (0, _get_console_text_pit.getPitApiTextForConsole)(jobTitle, indexPatternTitle, searchSource, csvConfig));
    const consoleLocator = locators.get('CONSOLE_APP_LOCATOR');
    consoleLocator === null || consoleLocator === void 0 ? void 0 : consoleLocator.navigate({
      loadFrom: `data:text/plain,${queryUri}`
    });
  }, [searchSourceStart, serializedSearchSource, jobTitle, pagingStrategy, csvConfig, locators]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "reportInfoFlyoutOpenInConsoleButton",
    key: "download",
    icon: "wrench",
    onClick: handleDevToolsLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.openInConsole', {
    defaultMessage: 'Inspect query in Console',
    description: 'An option in a menu of actions.'
  }));
};
const InspectInConsoleButton = props => {
  const {
    config,
    job
  } = props;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    application,
    data,
    share
  } = services;
  const {
    capabilities
  } = application;
  const {
    locators
  } = share.url;

  // To show the Console button,
  // check if job object type is search,
  // and if both the Dev Tools UI and the Console UI are enabled.
  const canShowDevTools = job.objectType === 'search' && capabilities.dev_tools.show;
  if (!canShowDevTools) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(InspectInConsoleButtonUi, {
    searchSourceStart: data.search.searchSource,
    locators: locators,
    job: job,
    csvConfig: config.csv,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
};
exports.InspectInConsoleButton = InspectInConsoleButton;