"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudSetupInstructions = getCloudSetupInstructions;
var _registry = require("@kbn/fleet-plugin/server/services/epm/registry");
var _common = require("@kbn/profiling-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getCloudSetupInstructions({
  packagePolicyClient,
  soClient,
  apmServerHost,
  stackVersion
}) {
  var _apmServerHost$replac, _collectorVars$secret;
  const profilerAgent = await (0, _registry.fetchFindLatestPackageOrThrow)('profiler_agent', {
    prerelease: true
  });
  const collectorPolicy = await (0, _common.getCollectorPolicy)({
    packagePolicyClient,
    soClient
  });
  const symbolizerPolicy = await (0, _common.getSymbolizerPolicy)({
    packagePolicyClient,
    soClient
  });
  if (!collectorPolicy) {
    throw new Error('Could not find Collector policy');
  }
  if (!symbolizerPolicy) {
    throw new Error('Could not find Symbolizer policy');
  }
  const collectorVars = collectorPolicy.inputs[0].vars;
  const symbolizerHost = apmServerHost === null || apmServerHost === void 0 ? void 0 : apmServerHost.replace(/\.apm\./, '.symbols.');
  const collectorHost = apmServerHost === null || apmServerHost === void 0 ? void 0 : (_apmServerHost$replac = apmServerHost.replace(/\.apm\./, '.profiling.')) === null || _apmServerHost$replac === void 0 ? void 0 : _apmServerHost$replac.replace('https://', '');
  return {
    collector: {
      secretToken: collectorVars === null || collectorVars === void 0 ? void 0 : (_collectorVars$secret = collectorVars.secret_token) === null || _collectorVars$secret === void 0 ? void 0 : _collectorVars$secret.value,
      host: collectorHost
    },
    symbolizer: {
      host: symbolizerHost
    },
    profilerAgent: {
      version: profilerAgent.version
    },
    stackVersion
  };
}