"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackViewInLensAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _use_pack_query_last_results = require("../packs/use_pack_query_last_results");
var _pack_queries_status_table = require("../live_queries/form/pack_queries_status_table");
var _view_results_in_lens = require("./view_results_in_lens");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/lens/pack_view_in_lens.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PackViewInLensActionComponent = ({
  item
}) => {
  const {
    action_id: actionId,
    interval
  } = item;
  const {
    data: lastResultsData
  } = (0, _use_pack_query_last_results.usePackQueryLastResults)({
    actionId,
    interval
  });
  const startDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).subtract(interval, 'seconds').toISOString() : `now-${interval}s`;
  const endDate = lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'] ? (0, _momentTimezone.default)(lastResultsData === null || lastResultsData === void 0 ? void 0 : lastResultsData['@timestamp'][0]).toISOString() : 'now';
  return /*#__PURE__*/_react.default.createElement(_view_results_in_lens.ViewResultsInLensAction, {
    actionId: actionId,
    buttonType: _pack_queries_status_table.ViewResultsActionButtonType.icon,
    startDate: startDate,
    endDate: endDate,
    mode: lastResultsData !== null && lastResultsData !== void 0 && lastResultsData['@timestamp'][0] ? 'absolute' : 'relative',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
const PackViewInLensAction = exports.PackViewInLensAction = /*#__PURE__*/_react.default.memo(PackViewInLensActionComponent);