"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundLayout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  container: _i18n.i18n.translate('xpack.onechat.round.container', {
    defaultMessage: 'Conversation round'
  }),
  userMessage: _i18n.i18n.translate('xpack.onechat.round.userInput', {
    defaultMessage: 'User input'
  })
};
const RoundLayout = ({
  input,
  outputIcon,
  output,
  isResponseLoading,
  isCurrentRound,
  scrollContainerHeight
}) => {
  const [roundContainerMinHeight, setRoundContainerMinHeight] = (0, _react2.useState)(0);
  (0, _react2.useEffect)(() => {
    if (isCurrentRound && isResponseLoading) {
      setRoundContainerMinHeight(scrollContainerHeight);
    } else if (!isCurrentRound) {
      setRoundContainerMinHeight(0);
    }
  }, [isCurrentRound, isResponseLoading, scrollContainerHeight]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const inputContainerStyles = (0, _react.css)`
    width: 100%;
    align-self: end;
    max-inline-size: 80%;
    background-color: ${euiTheme.colors.backgroundBasePrimary};
  `;
  const roundContainerStyles = (0, _react.css)`
    ${roundContainerMinHeight > 0 ? `min-height: ${roundContainerMinHeight}px;` : ''}
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "aria-label": labels.container,
    css: roundContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    css: inputContainerStyles,
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false,
    "aria-label": labels.userMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, input)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, outputIcon), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, output))));
};
exports.RoundLayout = RoundLayout;