"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatAgents = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../common/doc_links");
var _agents_list = require("./agents_list");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _delete_agent_context = require("../../../context/delete_agent_context");
var _tech_preview = require("../../common/tech_preview");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/list/agents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OnechatAgents = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    manageAgents
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const headerStyles = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
    border: none;
  `;
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const headerButtons = [manageAgents && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plus",
    color: "primary",
    fill: true,
    iconSide: "left",
    href: createOnechatUrl(_app_paths.appPaths.agents.new),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.newAgentButton', {
    defaultMessage: 'New agent'
  }))];
  return /*#__PURE__*/_react.default.createElement(_delete_agent_context.DeleteAgentProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    css: headerStyles,
    pageTitle: /*#__PURE__*/_react.default.createElement(_tech_preview.TechPreviewTitle, {
      title: _i18n.i18n.translate('xpack.onechat.agents.title', {
        defaultMessage: 'Agents'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.agents.description",
      defaultMessage: "Define agents with custom instructions and assign them {toolsLink} to answer questions about your data and take actions on your behalf. {learnMoreLink}",
      values: {
        toolsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: createOnechatUrl(_app_paths.appPaths.tools.list),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.onechat.agents.toolsLinkText', {
          defaultMessage: 'tools'
        })),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.agentBuilderAgents,
          target: "_blank",
          "aria-label": _i18n.i18n.translate('xpack.onechat.agents.agentsDocumentationAriaLabel', {
            defaultMessage: 'Learn more about agents in the documentation'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.onechat.agents.agentsDocumentation', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }),
    rightSideItems: headerButtons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agents_list.AgentsList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }))));
};
exports.OnechatAgents = OnechatAgents;