"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CoreVitals;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _core_vital_item = require("./core_vital_item");
var _web_core_vitals_title = require("./web_core_vitals_title");
var _service_name = require("./service_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/ux/core_web_vitals/core_vitals.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function formatToSec(value, fromUnit = 'MicroSec') {
  const valueInMs = Number(value !== null && value !== void 0 ? value : 0) / (fromUnit === 'MicroSec' ? 1000 : 1);
  if (valueInMs < 1000) {
    return valueInMs.toFixed(0) + ' ms';
  }
  return (valueInMs / 1000).toFixed(2) + ' s';
}
function formatToMilliseconds(value) {
  if (typeof value === 'undefined' || value === null) {
    return null;
  }
  return formatToSec(value, 'ms');
}
const CoreVitalsThresholds = {
  LCP: {
    good: '2.5s',
    bad: '4.0s'
  },
  INP: {
    good: '200ms',
    bad: '500ms'
  },
  CLS: {
    good: '0.1',
    bad: '0.25'
  }
};

// eslint-disable-next-line import/no-default-export
function CoreVitals({
  data,
  loading,
  displayServiceName,
  serviceName,
  totalPageViews,
  displayTrafficMetric = false
}) {
  var _cls$toFixed;
  const {
    lcp,
    lcpRanks,
    inp,
    inpRanks,
    cls,
    clsRanks,
    coreVitalPages
  } = data || {};
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_web_core_vitals_title.WebCoreVitalsTitle, {
    loading: loading,
    coreVitalPages: coreVitalPages,
    totalPageViews: totalPageViews,
    displayTrafficMetric: displayTrafficMetric,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), displayServiceName && /*#__PURE__*/React.createElement(_service_name.ServiceName, {
    name: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 30
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    justifyContent: 'spaceBetween',
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: {
      flexBasis: 380
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_core_vital_item.CoreVitalItem, {
    title: _translations.LCP_LABEL,
    value: formatToMilliseconds(lcp),
    ranks: lcpRanks,
    loading: loading,
    thresholds: CoreVitalsThresholds.LCP,
    helpLabel: _translations.LCP_HELP_LABEL,
    dataTestSubj: 'lcp-core-vital',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: {
      flexBasis: 380
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_core_vital_item.CoreVitalItem, {
    title: _translations.INP_LABEL,
    value: formatToMilliseconds(inp),
    ranks: inpRanks,
    loading: loading,
    thresholds: CoreVitalsThresholds.INP,
    helpLabel: _translations.INP_HELP_LABEL,
    dataTestSubj: 'inp-core-vital',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: {
      flexBasis: 380
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_core_vital_item.CoreVitalItem, {
    title: _translations.CLS_LABEL,
    value: (_cls$toFixed = cls === null || cls === void 0 ? void 0 : cls.toFixed(3)) !== null && _cls$toFixed !== void 0 ? _cls$toFixed : null,
    ranks: clsRanks,
    loading: loading,
    thresholds: CoreVitalsThresholds.CLS,
    isCls: true,
    helpLabel: _translations.CLS_HELP_LABEL,
    dataTestSubj: 'cls-core-vital',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }))));
}
module.exports = exports.default;