"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Expressions;
exports.defaultExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/stack-alerts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _alertingComparators = require("@kbn/alerting-comparators");
var _kibana_react = require("../../utils/kibana_react");
var _types = require("../../../common/custom_threshold_rule/types");
var _expression_row = require("./components/expression_row");
var _group_by = require("./components/group_by");
var _rule_condition_chart = require("../rule_condition_chart/rule_condition_chart");
var _get_search_configuration = require("./helpers/get_search_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/custom_threshold_rule_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HIDDEN_FILTER_PANEL_OPTIONS = ['pinFilter', 'disableFilter'];
const defaultExpression = exports.defaultExpression = {
  comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
  metrics: [{
    name: 'A',
    aggType: _types.Aggregators.COUNT
  }],
  threshold: [100],
  timeSize: 1,
  timeUnit: 'm'
};
const FILTER_TYPING_DEBOUNCE_MS = 500;
const EMPTY_FILTERS = [];

// eslint-disable-next-line import/no-default-export
function Expressions(props) {
  var _ruleParams$searchCon6, _ruleParams$searchCon7, _ruleParams$searchCon8;
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata,
    onChangeMetaData
  } = props;
  const {
    data,
    dataViews,
    dataViewEditor,
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const hasGroupBy = (0, _react.useMemo)(() => !!ruleParams.groupBy && ruleParams.groupBy.length > 0, [ruleParams.groupBy]);
  const [timeSize, setTimeSize] = (0, _react.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react.useState)('m');
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewTimeFieldError, setDataViewTimeFieldError] = (0, _react.useState)();
  const [searchSource, setSearchSource] = (0, _react.useState)();
  const [triggerResetDataView, setTriggerResetDataView] = (0, _react.useState)(false);
  const [paramsError, setParamsError] = (0, _react.useState)();
  const [paramsWarning, setParamsWarning] = (0, _react.useState)();
  const [savedQuery, setSavedQuery] = (0, _react.useState)();
  const [isNoDataChecked, setIsNoDataChecked] = (0, _react.useState)(hasGroupBy && !!ruleParams.alertOnGroupDisappear || !hasGroupBy && !!ruleParams.alertOnNoData);
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  const initSearchSource = async (resetDataView, thisData) => {
    let initialSearchConfiguration = resetDataView ? undefined : ruleParams.searchConfiguration;
    if (!initialSearchConfiguration || !initialSearchConfiguration.index) {
      var _metadata$currentOpti;
      if (!resetDataView && metadata !== null && metadata !== void 0 && (_metadata$currentOpti = metadata.currentOptions) !== null && _metadata$currentOpti !== void 0 && _metadata$currentOpti.searchConfiguration) {
        var _ruleParams$searchCon, _ruleParams$searchCon2;
        initialSearchConfiguration = {
          query: {
            query: (_ruleParams$searchCon = (_ruleParams$searchCon2 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon2 === void 0 ? void 0 : _ruleParams$searchCon2.query) !== null && _ruleParams$searchCon !== void 0 ? _ruleParams$searchCon : '',
            language: 'kuery'
          },
          ...metadata.currentOptions.searchConfiguration
        };
      } else {
        const newSearchSource = thisData.search.searchSource.createEmpty();
        newSearchSource.setField('query', thisData.query.queryString.getDefaultQuery());
        const defaultDataView = await thisData.dataViews.getDefaultDataView();
        if (defaultDataView) {
          newSearchSource.setField('index', defaultDataView);
          setDataView(defaultDataView);
        }
        initialSearchConfiguration = (0, _get_search_configuration.getSearchConfiguration)(newSearchSource.getSerializedFields(), setParamsWarning);
      }
    }
    try {
      var _ruleParams$searchCon3;
      const createdSearchSource = await thisData.search.searchSource.create(initialSearchConfiguration);
      setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
        ...initialSearchConfiguration,
        ...(!resetDataView && ((_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : _ruleParams$searchCon3.query) && {
          query: ruleParams.searchConfiguration.query
        })
      }, setParamsWarning));
      setSearchSource(createdSearchSource);
      setDataView(createdSearchSource.getField('index'));
      if (createdSearchSource.getField('index')) {
        var _createdSearchSource$;
        const timeFieldName = (_createdSearchSource$ = createdSearchSource.getField('index')) === null || _createdSearchSource$ === void 0 ? void 0 : _createdSearchSource$.timeFieldName;
        if (!timeFieldName) {
          setDataViewTimeFieldError(_i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.dataViewError.noTimestamp', {
            defaultMessage: 'The selected data view does not have a timestamp field, please select another data view.'
          }));
        } else {
          setDataViewTimeFieldError(undefined);
        }
      } else {
        setDataViewTimeFieldError(undefined);
      }
      setParamsError(undefined);
    } catch (error) {
      setParamsError(error);
    }
  };
  (0, _react.useEffect)(() => {
    initSearchSource(false, data);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource, data.dataViews, dataView]);
  (0, _react.useEffect)(() => {
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      preFillCriteria();
    }
    if (!ruleParams.groupBy) {
      preFillGroupBy();
    }
    if (typeof ruleParams.alertOnNoData === 'undefined') {
      preFillAlertOnNoData();
    }
    if (typeof ruleParams.alertOnGroupDisappear === 'undefined') {
      preFillAlertOnGroupDisappear();
    }
    setIsNoDataChecked(hasGroupBy && !!ruleParams.alertOnGroupDisappear || !hasGroupBy && !!ruleParams.alertOnNoData);
  }, [metadata]); // eslint-disable-line react-hooks/exhaustive-deps

  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    const ruleCriteria = (ruleParams.criteria ? ruleParams.criteria.slice() : []).map(criterion => {
      var _criterion$metrics;
      (_criterion$metrics = criterion.metrics) === null || _criterion$metrics === void 0 ? void 0 : _criterion$metrics.forEach(metric => {
        metric.field = undefined;
      });
      return criterion;
    });
    setRuleParams('criteria', ruleCriteria);
    searchSource === null || searchSource === void 0 ? void 0 : searchSource.setParent(undefined).setField('index', newDataView);
    setRuleParams('searchConfiguration', searchSource && (0, _get_search_configuration.getSearchConfiguration)(searchSource.getSerializedFields(), setParamsWarning));
    setDataView(newDataView);
  }, [ruleParams.criteria, searchSource, setRuleParams]);
  const updateParams = (0, _react.useCallback)((id, e) => {
    const ruleCriteria = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    ruleCriteria[id] = e;
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react.useCallback)(() => {
    var _ruleParams$criteria;
    const ruleCriteria = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    ruleCriteria.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react.useCallback)(id => {
    var _ruleParams$criteria2;
    const ruleCriteria = ((_ruleParams$criteria2 = ruleParams.criteria) === null || _ruleParams$criteria2 === void 0 ? void 0 : _ruleParams$criteria2.filter((_, index) => index !== id)) || [];
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);

  // Saved query
  const onSavedQueryUpdated = (0, _react.useCallback)(newSavedQuery => {
    setSavedQuery(newSavedQuery);
    const {
      filters: newFilters,
      query: newQuery
    } = newSavedQuery.attributes;

    // Only update fields if they are defined
    const updates = {};
    if (newFilters !== undefined) updates.filter = newFilters;
    if (newQuery !== undefined) updates.query = newQuery;
    if (Object.keys(updates).length > 0) {
      setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
        ...ruleParams.searchConfiguration,
        ...updates
      }, setParamsWarning));
    }
  }, [setRuleParams, ruleParams.searchConfiguration]);
  const onClearSavedQuery = () => {
    var _ruleParams$searchCon4, _ruleParams$searchCon5;
    setSavedQuery(undefined);
    setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
      ...ruleParams.searchConfiguration,
      query: {
        language: (_ruleParams$searchCon4 = (_ruleParams$searchCon5 = ruleParams.searchConfiguration.query) === null || _ruleParams$searchCon5 === void 0 ? void 0 : _ruleParams$searchCon5.language) !== null && _ruleParams$searchCon4 !== void 0 ? _ruleParams$searchCon4 : 'kuery',
        query: ''
      },
      filter: undefined
    }, setParamsWarning));
  };
  const onFilterUpdated = (0, _react.useCallback)(filter => {
    setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
      ...ruleParams.searchConfiguration,
      filter
    }, setParamsWarning));
  }, [setRuleParams, ruleParams.searchConfiguration]);
  const onQuerySubmit = (0, _react.useCallback)(({
    query: newQuery
  }) => {
    setParamsWarning(undefined);
    if (!(0, _fastDeepEqual.default)(newQuery, ruleParams.searchConfiguration.query)) {
      var _newQuery$language, _newQuery$query;
      setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
        ...ruleParams.searchConfiguration,
        query: {
          language: (_newQuery$language = newQuery === null || newQuery === void 0 ? void 0 : newQuery.language) !== null && _newQuery$language !== void 0 ? _newQuery$language : 'kuery',
          query: (_newQuery$query = newQuery === null || newQuery === void 0 ? void 0 : newQuery.query) !== null && _newQuery$query !== void 0 ? _newQuery$query : ''
        }
      }, setParamsWarning));
    }
  }, [setRuleParams, ruleParams.searchConfiguration]);
  const onQueryChange = (0, _react.useCallback)(({
    query: newQuery
  }) => {
    setParamsWarning(undefined);
    if (!(0, _fastDeepEqual.default)(newQuery, ruleParams.searchConfiguration.query)) {
      setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
        ...ruleParams.searchConfiguration,
        query: newQuery !== null && newQuery !== void 0 ? newQuery : ruleParams.searchConfiguration.query
      }, setParamsWarning));
    }
  }, [setRuleParams, ruleParams.searchConfiguration]);
  const debouncedOnQueryChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(onQueryChange, FILTER_TYPING_DEBOUNCE_MS), [onQueryChange]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    const hasGroup = !!group && group.length > 0;
    setRuleParams('groupBy', group && group.length ? group : '');
    setRuleParams('alertOnGroupDisappear', hasGroup && isNoDataChecked);
    setRuleParams('alertOnNoData', !hasGroup && isNoDataChecked);
  }, [setRuleParams, isNoDataChecked]);
  const emptyError = (0, _react.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    var _ruleParams$criteria3;
    const ruleCriteria = ((_ruleParams$criteria3 = ruleParams.criteria) === null || _ruleParams$criteria3 === void 0 ? void 0 : _ruleParams$criteria3.map(c => ({
      ...c,
      timeSize: ts
    }))) || [];
    setTimeSize(ts || undefined);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    var _ruleParams$criteria4;
    const ruleCriteria = ((_ruleParams$criteria4 = ruleParams.criteria) === null || _ruleParams$criteria4 === void 0 ? void 0 : _ruleParams$criteria4.map(c => ({
      ...c,
      timeUnit: tu
    }))) || [];
    setTimeUnit(tu);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const preFillCriteria = (0, _react.useCallback)(() => {
    var _md$currentOptions, _md$currentOptions$cr;
    const md = metadata;
    if (md !== null && md !== void 0 && (_md$currentOptions = md.currentOptions) !== null && _md$currentOptions !== void 0 && (_md$currentOptions$cr = _md$currentOptions.criteria) !== null && _md$currentOptions$cr !== void 0 && _md$currentOptions$cr.length) {
      const {
        timeSize: prefillTimeSize,
        timeUnit: prefillTimeUnit
      } = md.currentOptions.criteria[0];
      if (prefillTimeSize) setTimeSize(prefillTimeSize);
      if (prefillTimeUnit) setTimeUnit(prefillTimeUnit);
      setRuleParams('criteria', md.currentOptions.criteria.map(criterion => ({
        ...defaultExpression,
        ...criterion
      })));
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
  }, [metadata, setRuleParams]);
  const preFillGroupBy = (0, _react.useCallback)(() => {
    var _md$currentOptions2;
    const md = metadata;
    if (md && (_md$currentOptions2 = md.currentOptions) !== null && _md$currentOptions2 !== void 0 && _md$currentOptions2.groupBy) {
      setRuleParams('groupBy', md.currentOptions.groupBy);
    }
  }, [metadata, setRuleParams]);
  const preFillAlertOnNoData = (0, _react.useCallback)(() => {
    var _md$currentOptions3;
    const md = metadata;
    if (md && typeof ((_md$currentOptions3 = md.currentOptions) === null || _md$currentOptions3 === void 0 ? void 0 : _md$currentOptions3.alertOnNoData) !== 'undefined') {
      setRuleParams('alertOnNoData', md.currentOptions.alertOnNoData);
    } else {
      setRuleParams('alertOnNoData', false);
    }
  }, [metadata, setRuleParams]);
  const preFillAlertOnGroupDisappear = (0, _react.useCallback)(() => {
    var _md$currentOptions4;
    const md = metadata;
    if (md && typeof ((_md$currentOptions4 = md.currentOptions) === null || _md$currentOptions4 === void 0 ? void 0 : _md$currentOptions4.alertOnGroupDisappear) !== 'undefined') {
      setRuleParams('alertOnGroupDisappear', md.currentOptions.alertOnGroupDisappear);
    } else {
      setRuleParams('alertOnGroupDisappear', false);
    }
  }, [metadata, setRuleParams]);
  if (!paramsError && !searchSource) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 459,
          columnNumber: 32
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!paramsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.warning.title', {
      defaultMessage: 'Warning'
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "thresholdRuleExpressionWarning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 11
    }
  }, paramsWarning), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 482,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.selectDataViewPrompt",
    defaultMessage: "Select a data view",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 7
    }
  }), paramsError && !triggerResetDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    "data-test-subj": "thresholdRuleExpressionError",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.error.message', {
    defaultMessage: 'Error fetching search source'
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 500,
      columnNumber: 13
    }
  }), _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.error.messageDescription', {
    defaultMessage: 'Could not locate that data view (id: {id})',
    values: {
      id: paramsError === null || paramsError === void 0 ? void 0 : paramsError.savedObjectId
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleExpressionErrorButton",
    flush: "left",
    onClick: () => {
      initSearchSource(true, data);
      setTriggerResetDataView(true);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.error.message', {
    defaultMessage: 'Click here to choose a new data view'
  })))) : /*#__PURE__*/_react.default.createElement(_public.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    metadata: {
      adHocDataViewList: (metadata === null || metadata === void 0 ? void 0 : metadata.adHocDataViewList) || []
    },
    onSelectDataView: onSelectDataView,
    onChangeMetaData: ({
      adHocDataViewList
    }) => {
      onChangeMetaData({
        ...metadata,
        adHocDataViewList
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 9
    }
  }), dataViewTimeFieldError && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 9
    }
  }, dataViewTimeFieldError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 542,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 543,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 544,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.defineTextQueryPrompt",
    defaultMessage: "Define query filter (optional)",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 545,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 551,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "Custom threshold rule",
    iconType: "search",
    indexPatterns: dataView ? [dataView] : undefined,
    allowSavingQueries: true,
    showQueryInput: true,
    showQueryMenu: true,
    showFilterBar: true,
    showDatePicker: false,
    showSubmitButton: false,
    displayStyle: "inPage",
    onQueryChange: debouncedOnQueryChange,
    onQuerySubmit: onQuerySubmit,
    onClearSavedQuery: onClearSavedQuery,
    onSavedQueryUpdated: onSavedQueryUpdated,
    onSaved: onSavedQueryUpdated,
    dataTestSubj: "thresholdRuleUnifiedSearchBar",
    query: (_ruleParams$searchCon6 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon6 === void 0 ? void 0 : _ruleParams$searchCon6.query,
    filters: (_ruleParams$searchCon7 = (_ruleParams$searchCon8 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon8 === void 0 ? void 0 : _ruleParams$searchCon8.filter) !== null && _ruleParams$searchCon7 !== void 0 ? _ruleParams$searchCon7 : EMPTY_FILTERS,
    savedQuery: savedQuery,
    onFiltersUpdated: onFilterUpdated,
    hiddenFilterPanelOptions: HIDDEN_FILTER_PANEL_OPTIONS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 552,
      columnNumber: 7
    }
  }), errors.filterQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 9
    }
  }, errors.filterQuery), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 7
    }
  }), ruleParams.criteria && ruleParams.criteria.map((e, idx) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 584,
        columnNumber: 13
      }
    }, idx > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 585,
        columnNumber: 27
      }
    }), /*#__PURE__*/_react.default.createElement(_expression_row.ExpressionRow, {
      canDelete: ruleParams.criteria && ruleParams.criteria.length > 1 || false,
      fields: derivedIndexPattern.fields,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      dataView: derivedIndexPattern,
      title: ruleParams.criteria.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.setConditions",
        defaultMessage: "Set rule conditions",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 599,
          columnNumber: 21
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.condition",
        defaultMessage: "Condition {conditionNumber}",
        values: {
          conditionNumber: idx + 1
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 604,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 586,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
      metricExpression: e,
      dataView: dataView,
      searchConfiguration: ruleParams.searchConfiguration,
      groupBy: ruleParams.groupBy,
      error: errors[idx] || emptyError,
      timeRange: {
        from: `now-${(timeSize !== null && timeSize !== void 0 ? timeSize : 1) * 20}${timeUnit}`,
        to: 'now'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 612,
        columnNumber: 17
      }
    })));
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    display: "fullWidth",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 625,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 635,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleExpressionsAddConditionButton",
    color: "primary",
    iconSide: "left",
    flush: "left",
    iconType: "plusInCircleFilled",
    onClick: addExpression,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.addCondition",
    defaultMessage: "Add condition",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 650,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 651,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_group_by.GroupBy, {
    onChange: onGroupByChange,
    fields: derivedIndexPattern.fields,
    options: {
      groupBy: ruleParams.groupBy || null
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 668,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 676,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "metrics-alert-group-disappear-toggle",
    "data-test-subj": "thresholdRuleAlertOnNoDataCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertOnGroupDisappear', {
      defaultMessage: "Alert me if there's no data"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "question",
      color: "subdued",
      content: hasGroupBy ? _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.groupDisappearHelpText', {
        defaultMessage: 'Enable this to trigger a no data alert if a previously detected group begins to report no results. This is not recommended for dynamically scaling infrastructures that may rapidly start and stop nodes automatically.'
      }) : _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.noDataHelpText', {
        defaultMessage: 'Enable this to trigger a no data alert if the condition(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 688,
        columnNumber: 13
      }
    })),
    checked: isNoDataChecked,
    onChange: e => {
      const checked = e.target.checked;
      setIsNoDataChecked(checked);
      if (!checked) {
        setRuleParams('alertOnGroupDisappear', false);
        setRuleParams('alertOnNoData', false);
      } else {
        if (hasGroupBy) {
          setRuleParams('alertOnGroupDisappear', true);
          setRuleParams('alertOnNoData', false);
        } else {
          setRuleParams('alertOnGroupDisappear', false);
          setRuleParams('alertOnNoData', true);
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 677,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 729,
      columnNumber: 7
    }
  }));
}