"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateAnnotation = useUpdateAnnotation;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/hooks/use_update_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useUpdateAnnotation() {
  const {
    i18n: i18nStart,
    theme,
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const services = (0, _kibana_react.useKibana)().services;
  return (0, _reactQuery.useMutation)(['updateAnnotation'], async ({
    annotation
  }) => {
    if (!annotation.message) {
      var _annotation$annotatio, _annotation$annotatio2;
      annotation.message = (_annotation$annotatio = (_annotation$annotatio2 = annotation.annotation) === null || _annotation$annotatio2 === void 0 ? void 0 : _annotation$annotatio2.title) !== null && _annotation$annotatio !== void 0 ? _annotation$annotatio : '';
    }
    const body = JSON.stringify(annotation);
    return await http.put(`/api/observability/annotation/${annotation.id}`, {
      body
    });
  }, {
    onSuccess: (data, {
      annotation
    }) => {
      var _annotation$annotatio3, _annotation$annotatio4;
      toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
          coreStart: services,
          "data-test-subj": "observabilityMainContainer",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.observability.annotation.updated.successNotification",
          defaultMessage: "Successfully updated annotation {name}",
          values: {
            name: (_annotation$annotatio3 = (_annotation$annotatio4 = annotation.annotation) === null || _annotation$annotatio4 === void 0 ? void 0 : _annotation$annotatio4.title) !== null && _annotation$annotatio3 !== void 0 ? _annotation$annotatio3 : annotation.message
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 15
          }
        })), {
          i18n: i18nStart,
          theme
        })
      });
    },
    onError: (error, {
      annotation
    }, context) => {
      var _error$body$message, _error$body, _annotation$annotatio5, _annotation$annotatio6;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observability.update.annotation', {
          defaultMessage: 'Something went wrong while updating annotation {message}',
          values: {
            message: (_annotation$annotatio5 = (_annotation$annotatio6 = annotation.annotation) === null || _annotation$annotatio6 === void 0 ? void 0 : _annotation$annotatio6.title) !== null && _annotation$annotatio5 !== void 0 ? _annotation$annotatio5 : annotation.message
          }
        })
      });
    }
  });
}