"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FillOptions = FillOptions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/fill_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FillOptions() {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.fillOptions.legend', {
      defaultMessage: 'Fill'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "inside",
    name: "annotation.style.rect.fill",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      buttonSize: "compressed",
      isFullWidth: true,
      id: "fillOptions",
      idSelected: field.value,
      onChange: id => {
        field.onChange(id);
      },
      options: options,
      legend: _i18n.i18n.translate('xpack.observability.annotationForm.fillOptions.legend', {
        defaultMessage: 'Fill'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  })));
}
const options = [{
  id: 'inside',
  label: _i18n.i18n.translate('xpack.observability.annotationForm.fillOptions.inside', {
    defaultMessage: 'Inside'
  })
}, {
  id: 'outside',
  label: _i18n.i18n.translate('xpack.observability.annotationForm.fillOptions.outside', {
    defaultMessage: 'Outside'
  })
}];