"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFieldValue = exports.AlertsTableCellValue = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _get_related_columns = require("../../../pages/alert_details/components/related_alerts/get_related_columns");
var _relation_col = require("../../../pages/alert_details/components/related_alerts/relation_col");
var _paths = require("../../../../common/locators/paths");
var _formatters = require("../../../../common/utils/formatters");
var _alert_severity_badge = require("../../alert_severity_badge");
var _alert_status_indicator = require("../../alert_status_indicator");
var _parse_alert = require("../../../pages/alerts/helpers/parse_alert");
var _cell_tooltip = require("./cell_tooltip");
var _timestamp_tooltip = require("./timestamp_tooltip");
var _alert_actions = _interopRequireDefault(require("../../alert_actions/alert_actions"));
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alerts_table/common/cell_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAlertFieldValue = (alert, fieldName) => {
  // can be updated when working on https://github.com/elastic/kibana/issues/140819
  const rawValue = alert[fieldName];
  const value = Array.isArray(rawValue) ? rawValue.join() : rawValue;
  if (!(0, _lodash.isEmpty)(value)) {
    if (typeof value === 'object') {
      try {
        return JSON.stringify(value);
      } catch (e) {
        return 'Error: Unable to parse JSON value.';
      }
    }
    return value;
  }
  return '--';
};
exports.getAlertFieldValue = getAlertFieldValue;
/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */
// eslint-disable-next-line react/function-component-definition
const AlertsTableCellValue = props => {
  const {
    tableId,
    columnId,
    alert,
    rowIndex,
    onExpandedAlertIndexChange,
    observabilityRuleTypeRegistry,
    services: {
      http
    },
    parentAlert
  } = props;
  const cellRenderers = {
    [_ruleDataUtils.ALERT_STATUS]: value => {
      if (value !== _ruleDataUtils.ALERT_STATUS_ACTIVE && value !== _ruleDataUtils.ALERT_STATUS_RECOVERED) {
        // NOTE: This should only be needed to narrow down the type.
        // Status should be either "active" or "recovered".
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_alert_status_indicator.AlertStatusIndicator, {
        alertStatus: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 14
        }
      });
    },
    [_ruleDataUtils.TIMESTAMP]: value => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: new Date(value !== null && value !== void 0 ? value : '').getTime(),
      timeUnit: "milliseconds",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }),
    [_ruleDataUtils.ALERT_START]: value => tableId === 'xpack.observability.alerts.relatedAlerts' ? /*#__PURE__*/_react.default.createElement(_common.ElapsedTimestampTooltip, {
      time: new Date(value !== null && value !== void 0 ? value : '').getTime(),
      timeUnit: "milliseconds",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: new Date(value !== null && value !== void 0 ? value : '').getTime(),
      timeUnit: "milliseconds",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }),
    [_ruleDataUtils.ALERT_RULE_EXECUTION_TIMESTAMP]: value => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: new Date(value !== null && value !== void 0 ? value : '').getTime(),
      timeUnit: "milliseconds",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }),
    [_ruleDataUtils.ALERT_DURATION]: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _formatters.asDuration)(Number(value))),
    [_ruleDataUtils.ALERT_SEVERITY]: value => /*#__PURE__*/_react.default.createElement(_alert_severity_badge.AlertSeverityBadge, {
      severityLevel: value !== null && value !== void 0 ? value : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 34
      }
    }),
    [_ruleDataUtils.ALERT_EVALUATION_VALUE]: value => {
      const multipleValues = getAlertFieldValue(alert, _ruleDataUtils.ALERT_EVALUATION_VALUES);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, multipleValues !== null && multipleValues !== void 0 ? multipleValues : value);
    },
    [_ruleDataUtils.ALERT_REASON]: value => {
      if (!observabilityRuleTypeRegistry) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
      const parsedAlert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(alert);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "o11yGetRenderCellValueLink",
        css: {
          ':hover': {
            textDecoration: 'none'
          }
        },
        onClick: () => onExpandedAlertIndexChange(rowIndex),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }, parsedAlert.reason);
    },
    [_ruleDataUtils.ALERT_RULE_NAME]: value => {
      const ruleCategory = getAlertFieldValue(alert, _ruleDataUtils.ALERT_RULE_CATEGORY);
      const ruleId = getAlertFieldValue(alert, _ruleDataUtils.ALERT_RULE_UUID);
      const ruleLink = ruleId ? http.basePath.prepend(_paths.paths.observability.ruleDetails(ruleId)) : '';
      return /*#__PURE__*/_react.default.createElement(_cell_tooltip.CellTooltip, {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "o11yCellRenderersLink",
          href: ruleLink,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 13
          }
        }, value),
        tooltipContent: ruleCategory,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 9
        }
      });
    },
    [_get_related_columns.RELATION_COL]: value => {
      return /*#__PURE__*/_react.default.createElement(_relation_col.RelationCol, {
        alert: alert,
        parentAlert: parentAlert,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 14
        }
      });
    },
    [_get_related_columns.RELATED_ALERT_REASON]: value => {
      const val = getAlertFieldValue(alert, _ruleDataUtils.ALERT_REASON);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 14
        }
      }, val);
    },
    [_get_related_columns.RELATED_ACTIONS_COL]: val => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_alert_actions.default, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      })));
    },
    [_ruleDataUtils.ALERT_CASE_IDS]: value => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
    }
  };
  const val = getAlertFieldValue(alert, columnId);
  return cellRenderers[columnId] ? cellRenderers[columnId](val) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, val);
};
exports.AlertsTableCellValue = AlertsTableCellValue;