"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertStatusIndicator = AlertStatusIndicator;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _charts = require("@elastic/charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_status_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO update these colors to a more appropriate EUI color token
function AlertStatusIndicator({
  alertStatus,
  textSize = 'xs'
}) {
  if (alertStatus === _ruleDataUtils.ALERT_STATUS_ACTIVE) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: _charts.LEGACY_LIGHT_THEME.colors.vizColors[2],
      textSize: textSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.observability.alertsTGrid.statusActiveDescription', {
      defaultMessage: 'Active'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: _charts.LEGACY_LIGHT_THEME.colors.vizColors[1],
    textSize: textSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "relative",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability.alertsTGrid.statusRecoveredDescription', {
    defaultMessage: 'Recovered'
  })));
}