"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataIngestStatus = DataIngestStatus;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _common = require("@kbn/logs-shared-plugin/common");
var _telemetry_events = require("../../../../common/telemetry_events");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _progress_indicator = require("../shared/progress_indicator");
var _get_started_panel = require("../shared/get_started_panel");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _pricing_features = require("../../../../common/pricing_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/kubernetes/data_ingest_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FETCH_INTERVAL = 2000;
const SHOW_TROUBLESHOOTING_DELAY = 120000; // 2 minutes
const CLUSTER_OVERVIEW_DASHBOARD_ID = 'kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c';
function DataIngestStatus({
  onboardingId
}) {
  var _dashboardLocator$get, _logsLocator$getRedir;
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const [checkDataStartTime] = (0, _react.useState)(Date.now());
  const [dataReceivedTelemetrySent, setDataReceivedTelemetrySent] = (0, _react.useState)(false);
  const {
    services: {
      share,
      analytics
    }
  } = (0, _public.useKibana)();
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const logsLocator = share.url.locators.get(_common.LOGS_LOCATOR_ID);
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('GET /internal/observability_onboarding/kubernetes/{onboardingId}/has-data', {
      params: {
        path: {
          onboardingId
        }
      }
    });
  }, [onboardingId]);
  (0, _react.useEffect)(() => {
    const pendingStatusList = [_use_fetcher.FETCH_STATUS.LOADING, _use_fetcher.FETCH_STATUS.NOT_INITIATED];
    if (pendingStatusList.includes(status) || (data === null || data === void 0 ? void 0 : data.hasData) === true) {
      return;
    }
    const timeout = setTimeout(() => {
      refetch();
    }, FETCH_INTERVAL);
    return () => clearTimeout(timeout);
  }, [data === null || data === void 0 ? void 0 : data.hasData, refetch, status]);
  (0, _react.useEffect)(() => {
    if ((data === null || data === void 0 ? void 0 : data.hasData) === true && !dataReceivedTelemetrySent) {
      setDataReceivedTelemetrySent(true);
      analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT.eventType, {
        flow_type: 'kubernetes',
        flow_id: onboardingId,
        step: 'logs-ingest',
        step_status: 'complete'
      });
    }
  }, [analytics, data === null || data === void 0 ? void 0 : data.hasData, dataReceivedTelemetrySent, onboardingId]);
  const isTroubleshootingVisible = (data === null || data === void 0 ? void 0 : data.hasData) === false && Date.now() - checkDataStartTime > SHOW_TROUBLESHOOTING_DELAY;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
    title: data !== null && data !== void 0 && data.hasData ? 'We are monitoring your cluster' : 'Waiting for data to be shipped',
    iconType: "checkInCircleFilled",
    isLoading: !(data !== null && data !== void 0 && data.hasData),
    css: (0, _react2.css)`
          max-width: 40%;
        `,
    "data-test-subj": "observabilityOnboardingKubernetesPanelDataProgressIndicator",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), isTroubleshootingVisible && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.dataIngestStatus.troubleshootingTextLabel",
    defaultMessage: "Find more details and troubleshooting solutions in our documentation. {troubleshootingLink}",
    values: {
      troubleshootingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingDataIngestStatusTroubleshootingLink",
        href: "https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html",
        external: true,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.dataIngestStatus.troubleshootingLinkText', {
        defaultMessage: 'Open documentation'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }))), (data === null || data === void 0 ? void 0 : data.hasData) === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
    onboardingFlowType: "kubernetes",
    dataset: "kubernetes",
    integration: "kubernetes",
    onboardingId: onboardingId,
    newTab: false,
    isLoading: false,
    actionLinks: [metricsOnboardingEnabled ? {
      id: CLUSTER_OVERVIEW_DASHBOARD_ID,
      label: _i18n.i18n.translate('xpack.observability_onboarding.kubernetesPanel.exploreDashboard', {
        defaultMessage: 'Explore Kubernetes cluster'
      }),
      title: _i18n.i18n.translate('xpack.observability_onboarding.kubernetesPanel.monitoringCluster', {
        defaultMessage: 'Overview your Kubernetes cluster with this pre-made dashboard'
      }),
      href: (_dashboardLocator$get = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
        dashboardId: CLUSTER_OVERVIEW_DASHBOARD_ID
      })) !== null && _dashboardLocator$get !== void 0 ? _dashboardLocator$get : ''
    } : {
      id: 'logs',
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.logsTitle', {
        defaultMessage: 'View and analyze your logs:'
      }),
      label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.logsLabel', {
        defaultMessage: 'Explore logs'
      }),
      href: (_logsLocator$getRedir = logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({})) !== null && _logsLocator$getRedir !== void 0 ? _logsLocator$getRedir : ''
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  })));
}