"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMonitoringSSPTable = EuiMonitoringSSPTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("../setup_mode/formatting");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/table/eui_table_ssp.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EuiMonitoringSSPTable({
  rows: items,
  search = {},
  pagination,
  columns: _columns,
  onTableChange,
  setupMode,
  productName,
  ...props
}) {
  const [queryText, setQueryText] = _react.default.useState('');
  const [isLoading, setIsLoading] = _react.default.useState(false);
  const [page, setPage] = _react.default.useState({
    index: pagination.pageIndex,
    size: pagination.pageSize
  });
  if (!pagination.totalItemCount) {
    pagination.totalItemCount = items && items.length || 0;
  }
  const [sort, setSort] = _react.default.useState(props.sorting);
  if (search.box && !search.box['data-test-subj']) {
    search.box['data-test-subj'] = 'monitoringTableToolBar';
  }
  const columns = _columns.map(column => {
    if (!('sortable' in column)) {
      column.sortable = true;
    }
    return column;
  });
  let footerContent = null;
  if (setupMode && setupMode.enabled && (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    footerContent = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "flag",
      onClick: () => setupMode.openFlyout({}, true),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.monitoring.euiSSPTable.setupNewButtonLabel', {
      defaultMessage: 'Set up monitoring for new {identifier}',
      values: {
        identifier: (0, _formatting.getIdentifier)(productName)
      }
    })));
  }
  const onChange = async ({
    page,
    sort
  }) => {
    setPage(page);
    setSort({
      sort
    });
    // angular version
    if (props.fetchMoreData) {
      setIsLoading(true);
      await props.fetchMoreData({
        page,
        sort: {
          sort
        },
        queryText
      });
      setIsLoading(false);
      onTableChange({
        page,
        sort
      });
    }
    // react version
    else {
      onTableChange({
        page,
        sort,
        queryText
      });
    }
  };
  const onQueryChange = async ({
    queryText
  }) => {
    const newPage = {
      ...page,
      index: 0
    };
    setPage(newPage);
    setQueryText(queryText);
    // angular version
    if (props.fetchMoreData) {
      setIsLoading(true);
      await props.fetchMoreData({
        page: newPage,
        sort,
        queryText
      });
      setIsLoading(false);
    } else {
      // react version
      onTableChange({
        page,
        sort: sort.sort,
        queryText
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${props['data-test-subj']}Container`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, (0, _extends2.default)({}, search, {
    onChange: onQueryChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({}, props, {
    "data-test-subj": items.length ? 'monitoringTableHasData' : 'monitoringTableNoData',
    items: items,
    pagination: pagination,
    onChange: onChange,
    columns: columns,
    loading: props.isLoading || isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  })), footerContent);
}