"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatementList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _statement = require("./statement");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_viewer/views/statement_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getCollapsedChildIds(elements, collapsedIds) {
  const collapsedChildIds = new Set();
  elements.forEach(({
    id,
    parentId
  }) => {
    if (collapsedIds.has(parentId) || collapsedChildIds.has(parentId)) {
      collapsedChildIds.add(id);
    }
  });
  return collapsedChildIds;
}
class StatementList extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "expand", elementId => {
      const collapsedIds = new Set(this.state.collapsedIds);
      collapsedIds.delete(elementId);
      this.updateCollapsedElement(collapsedIds);
    });
    (0, _defineProperty2.default)(this, "collapse", elementId => {
      const collapsedIds = new Set(this.state.collapsedIds);
      collapsedIds.add(elementId);
      this.updateCollapsedElement(collapsedIds);
    });
    (0, _defineProperty2.default)(this, "updateCollapsedElement", collapsedIds => {
      const {
        elements
      } = this.props;
      const collapsedChildIds = getCollapsedChildIds(elements, collapsedIds);
      this.setState({
        collapsedIds,
        collapsedChildIds
      });
    });
    (0, _defineProperty2.default)(this, "elementIsCollapsed", elementId => this.state.collapsedIds.has(elementId));
    (0, _defineProperty2.default)(this, "renderStatement", element => {
      const {
        id,
        parentId
      } = element;
      const {
        onShowVertexDetails
      } = this.props;
      return this.state.collapsedIds.has(parentId) || this.state.collapsedChildIds.has(parentId) ? null : /*#__PURE__*/_react.default.createElement(_statement.Statement, {
        key: id,
        element: element,
        collapse: this.collapse,
        expand: this.expand,
        isCollapsed: this.elementIsCollapsed(id),
        onShowVertexDetails: onShowVertexDetails,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 7
        }
      });
    });
    this.state = {
      collapsedIds: new Set(),
      collapsedChildIds: new Set()
    };
  }
  render() {
    const {
      elements
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("ul", {
      className: "monPipelineViewer__list",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 12
      }
    }, elements.map(this.renderStatement));
  }
}
exports.StatementList = StatementList;
StatementList.propTypes = {
  elements: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    // top-level elements have null parentId
    parentId: _propTypes.default.string
  })).isRequired,
  onShowVertexDetails: _propTypes.default.func.isRequired
};