"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _elasticsearch_panel = require("./elasticsearch_panel");
var _kibana_panel = require("./kibana_panel");
var _logstash_panel = require("./logstash_panel");
var _beats_panel = require("./beats_panel");
var _eui = require("@elastic/eui");
var _apm_panel = require("./apm_panel");
var _enterprise_search_panel = require("./enterprise_search_panel");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/overview/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Overview(props) {
  const isFromStandaloneCluster = props.cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.overview.heading",
    defaultMessage: "Stack Monitoring Overview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 13
    }
  }))), !isFromStandaloneCluster ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticsearch_panel.ElasticsearchPanel, (0, _extends2.default)({}, props.cluster.elasticsearch, {
    version: props.cluster.version,
    ml: props.cluster.ml,
    license: props.cluster.license,
    setupMode: props.setupMode,
    showLicenseExpiration: props.showLicenseExpiration,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_kibana_panel.KibanaPanel, (0, _extends2.default)({}, props.cluster.kibana, {
    setupMode: props.setupMode,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_logstash_panel.LogstashPanel, (0, _extends2.default)({}, props.cluster.logstash, {
    setupMode: props.setupMode,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_beats_panel.BeatsPanel, (0, _extends2.default)({}, props.cluster.beats, {
    setupMode: props.setupMode,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_apm_panel.ApmPanel, (0, _extends2.default)({}, props.cluster.apm, {
    setupMode: props.setupMode,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_enterprise_search_panel.EnterpriseSearchPanel, (0, _extends2.default)({}, props.cluster.enterpriseSearch, {
    setupMode: props.setupMode,
    alerts: props.alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }))));
}