"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BeatsInstancePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _beat = require("../../../components/beats/beat");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _beats_template = require("./beats_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/beats/instance.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BeatsInstancePage = ({
  clusters
}) => {
  var _services$data2;
  const {
    instance
  } = (0, _reactRouterDom.useParams)();
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    services
  } = (0, _public.useKibana)();
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)({});
  const [beatName, setBeatName] = (0, _react.useState)('');
  const title = _i18n.i18n.translate('xpack.monitoring.beats.instance.routeTitle', {
    defaultMessage: 'Beats - {instanceName} - Overview',
    values: {
      instanceName: beatName
    }
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.beats.instance.pageTitle', {
    defaultMessage: 'Beat instance: {beatName}',
    values: {
      beatName
    }
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inBeats: true,
        instance: beatName
      });
    }
  }, [cluster, beatName, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/beats/beat/${instance}`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData(response);
    setBeatName((response === null || response === void 0 ? void 0 : response.summary.name) || '');
  }, [ccs, clusterUuid, instance, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_beats_template.BeatsTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    instance: instance,
    "data-test-subj": "beatDetailPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "monitoringBeatsInstanceApp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_beat.Beat, {
    summary: data.summary,
    metrics: data.metrics,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  })));
};
exports.BeatsInstancePage = BeatsInstancePage;