"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showAlertsToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _legacy_shims = require("../../legacy_shims");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/lib/alerts_toast.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const showApiKeyAndEncryptionError = services => {
  const settingsUrl = _legacy_shims.Legacy.shims.docLinks.links.alerting.generalSettings;
  _legacy_shims.Legacy.shims.toastNotifications.addWarning({
    title: _i18n.i18n.translate('xpack.monitoring.healthCheck.tlsAndEncryptionErrorTitle', {
      defaultMessage: 'Additional setup required'
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.monitoring.healthCheck.tlsAndEncryptionError', {
      defaultMessage: 'Stack Monitoring rules require API keys to be enabled and an encryption key to be configured.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: settingsUrl,
      external: true,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.monitoring.healthCheck.encryptionErrorAction', {
      defaultMessage: 'Learn how.'
    }))), services)
  });
};
const showAlertsCreatedConfirmation = () => {
  _legacy_shims.Legacy.shims.toastNotifications.addWarning({
    title: _i18n.i18n.translate('xpack.monitoring.healthCheck.alertsCreatedConfirmation.title', {
      defaultMessage: 'New alerts created'
    }),
    text: _i18n.i18n.translate('xpack.monitoring.healthCheck.alertsCreatedConfirmation.text', {
      defaultMessage: 'Review the alert definition using Setup mode and configure additional action connectors to get notified via your favorite method.'
    }),
    'data-test-subj': 'alertsCreatedToast'
  });
};
const showAlertsToast = (response, services) => {
  const {
    isSufficientlySecure,
    hasPermanentEncryptionKey
  } = response;
  if (isSufficientlySecure === false || hasPermanentEncryptionKey === false) {
    showApiKeyAndEncryptionError(services);
  } else {
    showAlertsCreatedConfirmation();
  }
};
exports.showAlertsToast = showAlertsToast;