"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexInputForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _inference_error = require("../../inference_error");
var _index_input = require("../index_input");
var _inference_base = require("../inference_base");
var _input_form_controls = require("./input_form_controls");
var _test_trained_models_context = require("../../test_trained_models_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/inference_input_form/index_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexInputForm = ({
  inferrer
}) => {
  const {
    currentContext: {
      defaultSelectedDataViewId,
      createPipelineFlyoutOpen
    }
  } = (0, _test_trained_models_context.useTestTrainedModelsContext)();
  const data = (0, _index_input.useIndexInput)({
    inferrer,
    defaultSelectedDataViewId
  });
  const {
    reloadExamples,
    selectedField
  } = data;
  const [errorText, setErrorText] = (0, _react.useState)(null);
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const examples = (0, _useObservable.default)(inferrer.getInputText$(), inferrer.getInputText());
  const isValid = (0, _useObservable.default)(inferrer.getIsValid$(), inferrer.getIsValid());
  const outputComponent = (0, _react.useMemo)(() => inferrer.getOutputComponent(), [inferrer]);
  const infoComponent = (0, _react.useMemo)(() => inferrer.getInfoComponent(), [inferrer]);
  const run = (0, _react.useCallback)(async event => {
    event.preventDefault();
    setErrorText(null);
    try {
      await inferrer.infer();
    } catch (e) {
      setErrorText((0, _mlErrorUtils.extractErrorMessage)(e));
    }
  }, [inferrer]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: 'form',
    onSubmit: run,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, infoComponent), /*#__PURE__*/_react.default.createElement(_index_input.InferenceInputFormIndexControls, {
    inferrer: inferrer,
    data: data,
    disableIndexSelection: defaultSelectedDataViewId !== undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_input_form_controls.InputFormControls, {
    testButtonDisabled: runningState === _inference_base.RUNNING_STATE.RUNNING || isValid === false,
    createPipelineButtonDisabled: runningState === _inference_base.RUNNING_STATE.RUNNING || isValid === false,
    showCreatePipelineButton: !createPipelineFlyoutOpen,
    inferrer: inferrer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, runningState === _inference_base.RUNNING_STATE.RUNNING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 53
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: reloadExamples,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING || selectedField === undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.reloadButton",
    defaultMessage: "Reload examples",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), errorText !== null || runningState === _inference_base.RUNNING_STATE.FINISHED_WITH_ERRORS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inference_error.ErrorMessage, {
    errorText: errorText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })) : null, runningState !== _inference_base.RUNNING_STATE.FINISHED ? examples.map(example => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, example), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }))) : null, runningState === _inference_base.RUNNING_STATE.FINISHED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, outputComponent) : null);
};
exports.IndexInputForm = IndexInputForm;