"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultModelsListState = exports.ModelsList = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _mlUrlState = require("@kbn/ml-url-state");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react2 = require("@emotion/react");
var _locator = require("../../../common/constants/locator");
var _storage = require("../../../common/types/storage");
var _trained_models = require("../../../common/types/trained_models");
var _ml_inference = require("../components/ml_inference");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _stats_bar = require("../components/stats_bar");
var _technical_preview_badge = require("../components/technical_preview_badge");
var _kibana = require("../contexts/kibana");
var _use_table_settings = require("../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _use_refresh = require("../routing/use_refresh");
var _config_mapping = require("./config_mapping");
var _delete_models_modal = require("./delete_models_modal");
var _model_actions = require("./model_actions");
var _test_dfa_models_flyout = require("./test_dfa_models_flyout");
var _test_models = require("./test_models");
var _use_init_trained_models_service = require("./hooks/use_init_trained_models_service");
var _model_status_indicator = require("./model_status_indicator");
var _ml_saved_objects_spaces_list = require("../components/ml_saved_objects_spaces_list");
var _use_spaces = require("../hooks/use_spaces");
var _saved_objects = require("../../../common/types/saved_objects");
var _space_management_context_wrapper = require("../components/space_management_context_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/models_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpandedRow = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./expanded_row')))).ExpandedRow
}));
const AddModelFlyout = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./add_model_flyout')))).AddModelFlyout
}));
const modelIdColumnName = _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelIdHeader', {
  defaultMessage: 'ID'
});
const getDefaultModelsListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: modelIdColumnName,
  sortDirection: 'asc',
  showAll: false
});
exports.getDefaultModelsListState = getDefaultModelsListState;
const isModelDeployed = item => (0, _trained_models.isNLPModelItem)(item) && item.state === _mlTrainedModelsUtils.MODEL_STATE.STARTED;
const ModelsList = ({
  pageState: pageStateExternal,
  updatePageState: updatePageStateExternal
}) => {
  var _pageState$queryText, _capabilities$savedOb;
  const {
    services: {
      spaces,
      application: {
        capabilities
      },
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const isInitialized = (0, _react.useRef)(false);
  const canManageSpacesAndSavedObjects = (0, _use_spaces.useCanManageSpacesAndSavedObjects)();
  const trainedModelsService = (0, _use_init_trained_models_service.useInitTrainedModelsService)();
  const items = (0, _useObservable.default)(trainedModelsService.modelItems$, trainedModelsService.modelItems);
  const isLoading = (0, _useObservable.default)(trainedModelsService.isLoading$, trainedModelsService.isLoading);
  const scheduledDeployments = (0, _useObservable.default)(trainedModelsService.scheduledDeployments$, trainedModelsService.scheduledDeployments);

  // Navigation blocker when there are active operations
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: scheduledDeployments.length > 0,
    blockSpaNavigation: false
  });
  const nlpElserDocUrl = docLinks.links.ml.nlpElser;
  const [isElserCalloutDismissed, setIsElserCalloutDismissed] = (0, _mlLocalStorage.useStorage)(_storage.ML_ELSER_CALLOUT_DISMISSED, false);
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });

  // allow for an internally controlled page state which stores the state in the URL
  // or an external page state, which is passed in as a prop.
  // external page state is used on the management page.
  const [pageStateInternal, updatePageStateInternal] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE, getDefaultModelsListState());
  const [pageState, updatePageState] = pageStateExternal && updatePageStateExternal ? [pageStateExternal, updatePageStateExternal] : [pageStateInternal, updatePageStateInternal];
  const refresh = (0, _use_refresh.useRefresh)();
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const canDeleteTrainedModels = capabilities.ml.canDeleteTrainedModels;
  const [selectedModels, setSelectedModels] = (0, _react.useState)([]);
  const [modelsToDelete, setModelsToDelete] = (0, _react.useState)([]);
  const [modelToDeploy, setModelToDeploy] = (0, _react.useState)();
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [modelToTest, setModelToTest] = (0, _react.useState)(null);
  const [dfaModelToTest, setDfaModelToTest] = (0, _react.useState)(null);
  const [isAddModelFlyoutVisible, setIsAddModelFlyoutVisible] = (0, _react.useState)(false);

  // List of downloaded/existing models
  const existingModels = (0, _react.useMemo)(() => {
    return items.filter(i => !(0, _trained_models.isModelDownloadItem)(i));
  }, [items]);
  const fetchModels = (0, _react.useCallback)(() => {
    trainedModelsService.fetchModels();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function checkInit() {
    if (!isInitialized.current && !isLoading) {
      isInitialized.current = true;
    }
  }, [isLoading]);
  (0, _react.useEffect)(function updateExpandedRows() {
    // Update expanded rows when items change
    setItemIdToExpandedRowMap(prevMap => {
      return Object.fromEntries(Object.keys(prevMap).map(modelId => {
        const item = items.find(i => i.model_id === modelId);
        return item ? [modelId, /*#__PURE__*/_react.default.createElement(ExpandedRow, {
          item: item,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 37
          }
        })] : [];
      }));
    });
  }, [items]);
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    if (!refresh) return;
    fetchModels();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refresh]);
  const modelsStats = (0, _react.useMemo)(() => {
    return {
      total: {
        show: true,
        value: existingModels.length,
        label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.totalAmountLabel', {
          defaultMessage: 'Total trained models'
        })
      }
    };
  }, [existingModels]);

  /**
   * Unique inference types from models
   */
  const inferenceTypesOptions = (0, _react.useMemo)(() => {
    const result = existingModels.reduce((acc, item) => {
      const type = item.inference_config && Object.keys(item.inference_config)[0];
      if (type) {
        acc.add(type);
      }
      if (item.model_type) {
        acc.add(item.model_type);
      }
      return acc;
    }, new Set());
    return [...result].sort((a, b) => a.localeCompare(b)).map(v => ({
      value: v,
      name: v
    }));
  }, [existingModels]);
  const modelAndDeploymentIds = (0, _react.useMemo)(() => {
    const nlpModels = existingModels.filter(_trained_models.isNLPModelItem);
    return [...new Set([...nlpModels.flatMap(v => v.deployment_ids), ...nlpModels.map(i => i.model_id)])];
  }, [existingModels]);
  const onModelDownloadRequest = (0, _react.useCallback)(async modelId => {
    trainedModelsService.downloadModel(modelId);
  }, [trainedModelsService]);

  /**
   * Table actions
   */
  const actions = (0, _model_actions.useModelActions)({
    onTestAction: setModelToTest,
    onDfaTestAction: setDfaModelToTest,
    onModelsDeleteRequest: setModelsToDelete,
    onModelDeployRequest: setModelToDeploy,
    modelAndDeploymentIds,
    onModelDownloadRequest
  });
  const shouldDisableSpacesColumn = !canManageSpacesAndSavedObjects || !((_capabilities$savedOb = capabilities.savedObjectsManagement) !== null && _capabilities$savedOb !== void 0 && _capabilities$savedOb.shareIntoSpace);
  const toggleDetails = async item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[item.model_id]) {
      delete itemIdToExpandedRowMapValues[item.model_id];
    } else {
      itemIdToExpandedRowMapValues[item.model_id] = /*#__PURE__*/_react.default.createElement(ExpandedRow, {
        item: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 53
        }
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    isExpander: true,
    align: 'center',
    render: item => {
      if ((0, _trained_models.isModelDownloadItem)(item) || !item.stats) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: toggleDetails.bind(null, item),
        "aria-label": itemIdToExpandedRowMap[item.model_id] ? _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.collapseRow', {
          defaultMessage: 'Collapse'
        }) : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.expandRow', {
          defaultMessage: 'Expand'
        }),
        iconType: itemIdToExpandedRowMap[item.model_id] ? 'arrowDown' : 'arrowRight',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 11
        }
      });
    },
    'data-test-subj': 'mlModelsTableRowDetailsToggle'
  }, {
    name: modelIdColumnName,
    sortable: ({
      model_id: modelId
    }) => modelId,
    truncateText: false,
    textOnly: false,
    'data-test-subj': 'mlModelsTableColumnId',
    render: item => {
      const {
        description,
        model_id: modelId,
        type
      } = item;
      const isTechPreview = (description === null || description === void 0 ? void 0 : description.includes('(Tech Preview)')) || (0, _trained_models.isNLPModelItem)(item) && item.techPreview;
      let descriptionText = description === null || description === void 0 ? void 0 : description.replace('(Tech Preview)', '');
      let tooltipContent = null;
      if ((0, _trained_models.isBaseNLPModelItem)(item)) {
        const {
          disclaimer,
          recommended,
          supported
        } = item;
        if (disclaimer) {
          descriptionText += '. ' + disclaimer;
        }
        tooltipContent = supported === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.notSupportedDownloadContent",
          defaultMessage: "Model version is not supported by your cluster's hardware configuration",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 348,
            columnNumber: 15
          }
        }) : recommended === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.notRecommendedDownloadContent",
          defaultMessage: "Model version is not optimized for your cluster's hardware configuration",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 15
          }
        }) : null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 'xs',
        direction: 'column',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 361,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 's',
        alignItems: 'center',
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 363,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        "data-test-subj": "mlModelsTableColumnIdValueId",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 364,
          columnNumber: 17
        }
      }, modelId)), isTechPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 367,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
        compressed: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 368,
          columnNumber: 19
        }
      })) : null), descriptionText ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: 'subdued',
        size: 'xs',
        "data-test-subj": "mlModelsTableColumnIdValueDescription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 374,
          columnNumber: 15
        }
      }, descriptionText, tooltipContent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: tooltipContent,
        type: "warning",
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 383,
          columnNumber: 21
        }
      })) : null) : null, Array.isArray(type) && type.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 'xs',
        direction: 'row',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 390,
          columnNumber: 15
        }
      }, type.map(t => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: t,
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "mlModelType",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 23
        }
      }, t))))) : null);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.stateHeader', {
      defaultMessage: 'Model state'
    }),
    truncateText: false,
    width: '150px',
    render: item => /*#__PURE__*/_react.default.createElement(_model_status_indicator.ModelStatusIndicator, {
      modelId: item.model_id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 45
      }
    }),
    'data-test-subj': 'mlModelsTableColumnDeploymentState'
  }, ...(canManageSpacesAndSavedObjects && spaces ? [{
    name: _i18n.i18n.translate('xpack.ml.jobsList.jobActionsColumn.spaces', {
      defaultMessage: 'Spaces'
    }),
    'data-test-subj': 'mlTableColumnSpaces',
    truncateText: true,
    align: 'right',
    width: '10%',
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_ml_saved_objects_spaces_list.MLSavedObjectsSpacesList, {
        disabled: shouldDisableSpacesColumn,
        spacesApi: spaces,
        spaceIds: item.spaces,
        id: item.model_id,
        mlSavedObjectType: _saved_objects.TRAINED_MODEL_SAVED_OBJECT_TYPE,
        refresh: fetchModels,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 427,
          columnNumber: 17
        }
      });
    }
  }] : []), {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.actionsHeader', {
      defaultMessage: 'Actions'
    }),
    width: '300px',
    actions,
    'data-test-subj': 'mlModelsTableColumnActions'
  }];
  const filters = inferenceTypesOptions && inferenceTypesOptions.length > 0 ? [{
    type: 'field_value_selection',
    field: 'type',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.typeFilter', {
      defaultMessage: 'Type'
    }),
    multiSelect: 'or',
    options: inferenceTypesOptions
  }] : [];
  const toolsLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.selectedModelsMessage",
    defaultMessage: "{modelsCount, plural, one{# model} other {# models}} selected",
    values: {
      modelsCount: selectedModels.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: setModelsToDelete.bind(null, selectedModels),
    "data-test-subj": "mlTrainedModelsDeleteSelectedModelsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModelsButtonLabel",
    defaultMessage: "Delete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 13
    }
  })))));
  const isSelectionAllowed = canDeleteTrainedModels;
  const selection = isSelectionAllowed ? {
    selectableMessage: (selectable, item) => {
      if (selectable) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.selectableMessage', {
          defaultMessage: 'Select a model'
        });
      }
      // TODO support multiple model downloads with selection
      if (!(0, _trained_models.isModelDownloadItem)(item) && (0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.disableSelectableMessage', {
          defaultMessage: 'Model has associated pipelines'
        });
      }
      if ((0, _trained_models.isBuiltInModel)(item)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.builtInModelMessage', {
          defaultMessage: 'Built-in model'
        });
      }
      if (isModelDeployed(item)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deployedModelMessage', {
          defaultMessage: 'Model is deployed'
        });
      }
      return '';
    },
    selectable: item => !(0, _trained_models.isModelDownloadItem)(item) && !(0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines) && !(0, _trained_models.isBuiltInModel)(item) && !isModelDeployed(item),
    onSelectionChange: selectedItems => {
      setSelectedModels(selectedItems);
    },
    selected: selectedModels
  } : undefined;
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_settings.useTableSettings)(items.length, pageState, updatePageState, true);
  const search = {
    query: searchQueryText,
    onChange: searchChange => {
      if (searchChange.error !== null) {
        return false;
      }
      updatePageState({
        queryText: searchChange.queryText,
        pageIndex: 0
      });
      return true;
    },
    box: {
      incremental: true
    },
    ...(inferenceTypesOptions && inferenceTypesOptions.length > 0 ? {
      filters
    } : {}),
    ...(selectedModels.length > 0 ? {
      toolsLeft
    } : {})
  };
  const isElserCalloutVisible = !isElserCalloutDismissed && items.findIndex(i => i.model_id === _mlTrainedModelsUtils.ELSER_ID_V1) >= 0;
  const euiMaxBreakpointXL = (0, _eui.useEuiMaxBreakpoint)('xl');
  const tableItems = (0, _react.useMemo)(() => {
    if (pageState.showAll) {
      return items;
    } else {
      // by default show only deployed models or recommended for download
      return items.filter(item => !(0, _trained_models.isModelDownloadItem)(item) || item.recommended);
    }
  }, [items, pageState.showAll]);
  if (!isInitialized.current) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlTrainedModelsList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_space_management_context_wrapper.SpaceManagementContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 586,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: fetchModels,
    forceRefresh: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 587,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 588,
      columnNumber: 9
    }
  }, modelsStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 590,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: modelsStats,
    dataTestSub: 'mlInferenceModelsStatsBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 595,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.showAllLabel",
      defaultMessage: "Show all",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 23
      }
    }),
    checked: !!pageState.showAll,
    onChange: e => updatePageState({
      showAll: e.target.checked
    }),
    "data-test-subj": "mlModelsShowAllSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 596,
      columnNumber: 19
    }
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: 'plusInCircle',
    color: 'primary',
    onClick: setIsAddModelFlyoutVisible.bind(null, true),
    "data-test-subj": "mlModelsAddTrainedModelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 612,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.addModelButtonLabel",
    defaultMessage: "Add trained model",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 626,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlModelsTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableLayout: 'auto',
    responsiveBreakpoint: 'xl',
    allowNeutralSort: false,
    columns: columns,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: tableItems,
    itemId: _config_mapping.ModelsTableToConfigMapping.id,
    loading: isLoading,
    search: search,
    selection: selection,
    rowProps: item => ({
      'data-test-subj': `mlModelsTableRow row-${item.model_id}`,
      // This is a workaround for https://github.com/elastic/eui/issues/8259
      css: (0, _react2.css)`
                ${euiMaxBreakpointXL} {
                  min-block-size: 10.875rem;
                }
              `
    }),
    pagination: pagination,
    onTableChange: onTableChange,
    sorting: sorting,
    "data-test-subj": isLoading ? 'mlModelsTable loading' : 'mlModelsTable loaded',
    childrenBetween: isElserCalloutVisible ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.newElserModelTitle",
        defaultMessage: "New ELSER model now available",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 658,
          columnNumber: 23
        }
      }),
      onDismiss: setIsElserCalloutDismissed.bind(null, true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 655,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.newElserModelDescription",
      defaultMessage: "A new version of ELSER that shows faster performance and improved relevance is now available. {docLink} for information on how to start using it.",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: nlpElserDocUrl,
          external: true,
          target: '_blank',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 670,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.startDeployment.viewElserDocLink",
          defaultMessage: "View documentation",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 671,
            columnNumber: 29
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 665,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 680,
        columnNumber: 19
      }
    })) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 11
    }
  })), modelsToDelete.length > 0 && /*#__PURE__*/_react.default.createElement(_delete_models_modal.DeleteModelsModal, {
    onClose: () => {
      setModelsToDelete([]);
    },
    onDelete: refreshList => {
      setItemIdToExpandedRowMap(prev => {
        const newMap = {
          ...prev
        };
        modelsToDelete.forEach(model => {
          delete newMap[model.model_id];
        });
        return newMap;
      });
      setModelsToDelete([]);
      setSelectedModels([]);
      if (refreshList) {
        fetchModels();
      }
    },
    models: modelsToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 687,
      columnNumber: 11
    }
  }), modelToTest === null ? null : /*#__PURE__*/_react.default.createElement(_test_models.TestModelAndPipelineCreationFlyout, {
    model: modelToTest,
    onClose: refreshList => {
      setModelToTest(null);
      if (refreshList) {
        fetchModels();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 711,
      columnNumber: 11
    }
  }), dfaModelToTest === null ? null : /*#__PURE__*/_react.default.createElement(_test_dfa_models_flyout.TestDfaModelsFlyout, {
    model: dfaModelToTest,
    onClose: setDfaModelToTest.bind(null, null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 722,
      columnNumber: 11
    }
  }), modelToDeploy !== undefined ? /*#__PURE__*/_react.default.createElement(_ml_inference.AddInferencePipelineFlyout, {
    onClose: setModelToDeploy.bind(null, undefined),
    model: modelToDeploy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 728,
      columnNumber: 11
    }
  }) : null, isAddModelFlyoutVisible ? /*#__PURE__*/_react.default.createElement(AddModelFlyout, {
    modelDownloads: items.filter(_trained_models.isModelDownloadItem),
    onClose: setIsAddModelFlyoutVisible.bind(null, false),
    onSubmit: modelId => {
      onModelDownloadRequest(modelId);
      setIsAddModelFlyoutVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 734,
      columnNumber: 11
    }
  }) : null));
};
exports.ModelsList = ModelsList;