"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElandPythonClient = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/eland_python_client.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElandPythonClient = ({
  supportedNlpModels,
  nlpImportModel
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step1Title', {
        defaultMessage: 'Install the Eland Python Client'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.pipInstallLabel",
        defaultMessage: "Eland can be installed with {pipLink} from {pypiLink}:",
        values: {
          pipLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://pypi.org/project/pip/',
            target: '_blank',
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 44,
              columnNumber: 25
            }
          }, "pip"),
          pypiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://pypi.org/',
            target: '_blank',
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 49,
              columnNumber: 25
            }
          }, "PyPI")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": 'mlElandPipInstallCodeBlock',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 19
        }
      }, "$ python -m pip install eland")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.condaInstallLabel",
        defaultMessage: "or it can also be installed with {condaLink} from {condaForgeLink}:",
        values: {
          condaLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://docs.conda.io/',
            target: '_blank',
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 72,
              columnNumber: 25
            }
          }, "Conda"),
          condaForgeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: 'https://conda-forge.org/',
            target: '_blank',
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 77,
              columnNumber: 25
            }
          }, "Conda Forge")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": "mlElandCondaInstallCodeBlock",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 19
        }
      }, " $ conda install -c conda-forge eland")))
    }, {
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Title', {
        defaultMessage: 'Importing your third-party model'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Body",
        defaultMessage: "Follow the instructions on importing compatible third-party models",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 21
        }
      }))), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2ExampleTitle",
        defaultMessage: "Example import",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        language: "shell",
        fontSize: 'm',
        "data-test-subj": 'mlElandExampleImportCodeBlock',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 19
        }
      }, "eland_import_hub_model ", /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 44
        }
      }), "--cloud-id <cloud-id> \\ ", /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 51
        }
      }), "-u <username> -p <password> \\ ", /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 63
        }
      }), "--hub-model-id <model-id> \\ ", /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 55
        }
      }), "--task-type ner \\")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: nlpImportModel,
        target: '_blank',
        iconType: 'help',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.importModelButtonLabel",
        defaultMessage: "Import models with Eland",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: supportedNlpModels,
        target: '_blank',
        iconType: 'help',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.compatibleModelsButtonLabel",
        defaultMessage: "Compatible NLP models",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 23
        }
      })))))
    }, {
      title: _i18n.i18n.translate('xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Title', {
        defaultMessage: 'Deploy your model'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Body",
        defaultMessage: "Click \u201CStart deployment\u201D in the table row containing your new model to deploy and use it.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 21
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step3Body",
        defaultMessage: "Note: The trained model list automatically refreshes with the most current imported models in your cluster. If the list is not updated, click the 'Refresh' button in the top right corner. Otherwise, revisit the instructions above to troubleshoot.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 21
        }
      }))))
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }));
};
exports.ElandPythonClient = ElandPythonClient;