"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_create_url = require("../../../../../contexts/kibana/use_create_url");
var _results_url = require("../../../../../util/results_url");
var _kibana = require("../../../../../contexts/kibana");
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _json_editor_flyout = require("../common/json_editor_flyout");
var _job_creator = require("../../../common/job_creator");
var _job_details = require("./components/job_details");
var _datafeed_details = require("./components/datafeed_details");
var _detector_chart = require("./components/detector_chart");
var _job_progress = require("./components/job_progress");
var _post_save_options = require("./components/post_save_options");
var _start_datafeed_switch = require("./components/start_datafeed_switch");
var _jobs_awaiting_node_warning = require("../../../../../components/jobs_awaiting_node_warning");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _general = require("../../../common/job_creator/util/general");
var _common = require("./components/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/summary_step/summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SummaryStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    services: {
      notifications,
      http: {
        basePath
      }
    }
  } = (0, _kibana.useMlKibana)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToMlManagement = (0, _use_create_url.useNavigateToManagementMlLink)('anomaly_detection');
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated,
    resultsLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [progress, setProgress] = (0, _react.useState)(resultsLoader.progress);
  const [creatingJob, setCreatingJob] = (0, _react.useState)(false);
  const [isValid, setIsValid] = (0, _react.useState)(jobValidator.validationSummary.basic);
  const [jobRunner, setJobRunner] = (0, _react.useState)(null);
  const [startDatafeed, setStartDatafeed] = (0, _react.useState)(true);
  const [showJobAssignWarning, setShowJobAssignWarning] = (0, _react.useState)(false);
  const isAdvanced = (0, _job_creator.isAdvancedJobCreator)(jobCreator);
  const jsonEditorMode = isAdvanced ? _json_editor_flyout.EDITOR_MODE.EDITABLE : _json_editor_flyout.EDITOR_MODE.READONLY;
  (0, _react.useEffect)(() => {
    jobCreator.subscribeToProgress(setProgress);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    let s = null;
    if (jobRunner !== null) {
      s = jobRunner.subscribeToJobAssignment(assigned => setShowJobAssignWarning(!assigned));
    }
    return () => {
      if (s !== null) {
        var _s;
        (_s = s) === null || _s === void 0 ? void 0 : _s.unsubscribe();
      }
    };
  }, [jobRunner]);
  async function start() {
    setCreatingJob(true);
    if (isAdvanced) {
      await createAdvancedJob();
    } else if (startDatafeed === true) {
      await createAndStartJob();
    } else {
      await createAdvancedJob(false);
    }
  }
  async function createAndStartJob() {
    try {
      const jr = await jobCreator.createAndStartJob();
      setJobRunner(jr);
    } catch (error) {
      handleJobCreationError(error);
    }
  }
  async function createAdvancedJob(showStartModal = true) {
    try {
      await jobCreator.createJob();
      await jobCreator.createDatafeed();
      (0, _general.advancedStartDatafeed)(showStartModal ? jobCreator : null, navigateToMlManagement);
    } catch (error) {
      handleJobCreationError(error);
    }
  }
  function handleJobCreationError(error) {
    const {
      displayErrorToast
    } = (0, _toast_notification_service.toastNotificationServiceProvider)(notifications.toasts);
    displayErrorToast(error, _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.createJobError', {
      defaultMessage: `Job creation error`
    }));
    setCreatingJob(false);
  }
  function viewResults() {
    const url = (0, _results_url.createResultsUrl)([jobCreator.jobId], jobCreator.start, jobCreator.end, (0, _job_creator.isSingleMetricJobCreator)(jobCreator) === true ? 'timeseriesexplorer' : 'explorer');
    navigateToPath(`${basePath.get()}/app/ml/${url}`);
  }
  function clickResetJob() {
    (0, _general.resetJob)(jobCreator, navigateToMlManagement);
  }
  const convertToAdvanced = () => {
    (0, _general.convertToAdvancedJob)(jobCreator, navigateToMlManagement);
  };
  (0, _react.useEffect)(() => {
    setIsValid(jobValidator.validationSummary.basic);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, isAdvanced && /*#__PURE__*/_react.default.createElement(_common.JobSectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 26
    }
  }), /*#__PURE__*/_react.default.createElement(_detector_chart.DetectorChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_job_progress.JobProgress, {
    progress: progress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_start_datafeed_switch.StartDatafeedSwitch, {
    startDatafeed: startDatafeed,
    setStartDatafeed: setStartDatafeed,
    disabled: creatingJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }), isAdvanced && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_common.DatafeedSectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_datafeed_details.DatafeedDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }), showJobAssignWarning && /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.NewJobAwaitingNodeWarning, {
    jobType: "anomaly-detector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 36
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, progress < 100 && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_wizard_nav.PreviousButton, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.VALIDATION),
    previousActive: creatingJob === false && isValid === true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: start,
    isDisabled: creatingJob === true || isValid === false,
    "data-test-subj": "mlJobWizardButtonCreateJob",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.createJobButton",
    defaultMessage: "Create job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 21
    }
  })))), creatingJob === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: progress > 0,
    jobEditorMode: jsonEditorMode,
    datafeedEditorMode: jsonEditorMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  })), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: convertToAdvanced,
    "data-test-subj": "mlJobWizardButtonConvertToAdvancedJob",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.convertToAdvancedButton",
    defaultMessage: "Convert to advanced job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 23
    }
  })))), progress > 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: viewResults,
    "data-test-subj": "mlJobWizardButtonViewResults",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.viewResultsButton",
    defaultMessage: "View results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 21
    }
  })))), progress === 100 && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: clickResetJob,
    "data-test-subj": "mlJobWizardButtonResetJob",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.resetJobButton",
    defaultMessage: "Reset job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_post_save_options.PostSaveOptions, {
    jobRunner: jobRunner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  })))));
};
exports.SummaryStep = SummaryStep;