"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrequencyInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _job_utils = require("../../../../../../../../../common/util/job_utils");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/datafeed_step/components/frequency/frequency_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FrequencyInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.frequency);
  const {
    value: frequency,
    setValue: setFrequency
  } = (0, _hooks.useStringifiedValue)(jobCreator.frequency);
  const [defaultFrequency, setDefaultFrequency] = (0, _react.useState)(createDefaultFrequency());
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'frequencyInput'
  });
  (0, _react.useEffect)(() => {
    jobCreator.frequency = frequency === '' ? null : frequency;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [frequency]);
  (0, _react.useEffect)(() => {
    setFrequency(jobCreator.frequency);
    const df = createDefaultFrequency();
    setDefaultFrequency(df);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.frequency);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  function createDefaultFrequency() {
    const df = (0, _job_utils.calculateDatafeedFrequencyDefaultSeconds)(jobCreator.bucketSpanMs / 1000);
    return `${df}s`;
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: frequency,
    placeholder: defaultFrequency,
    onChange: e => setFrequency(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputFrequency",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
};
exports.FrequencyInput = FrequencyInput;