"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeSelectorWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/start_datafeed_modal/time_range_selector/time_range_selector_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TimeRangeSelectorWrapper = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const style = {
    '.time-range-section-title': {
      fontWeight: 'bold',
      marginBottom: euiTheme.size.s
    },
    '.time-range-section': {
      flex: '50%',
      padding: `0 ${euiTheme.size.s}`,
      borderRight: euiTheme.border.thin
    },
    '.tab-stack': {
      marginBottom: 0,
      paddingLeft: 0,
      listStyle: 'none',
      '& > li': {
        float: 'none',
        position: 'relative',
        display: 'block',
        marginBottom: euiTheme.size.xs,
        '& > a': {
          position: 'relative',
          display: 'block',
          padding: `${euiTheme.size.s} ${euiTheme.size.base}`,
          borderRadius: euiTheme.border.radius.medium
        },
        '& > a:hover': {
          backgroundColor: euiTheme.colors.lightestShade
        },
        '.body': {
          display: 'none'
        }
      },
      '& > li.active': {
        '& > a': {
          color: euiTheme.colors.emptyShade,
          backgroundColor: euiTheme.colors.primary
        },
        '.body': {
          display: 'block',
          '.euiFieldText': {
            borderRadius: `0 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium}`
          }
        }
      },
      '& > li.has-body.active': {
        '& > a': {
          borderRadius: `${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0 0`
        },
        '.react-datepicker': {
          borderRadius: `0 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium}`,
          borderTop: 'none'
        }
      }
    },
    '.time-range-section:last-child': {
      borderRight: 'none'
    }
  };

  // @ts-expect-error style object strings cause a type error
  return /*#__PURE__*/_react.default.createElement("div", {
    css: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 10
    }
  }, children);
};
exports.TimeRangeSelectorWrapper = TimeRangeSelectorWrapper;