"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _anomaly_detection_kibana = _interopRequireDefault(require("./anomaly_detection_kibana.png"));
var _locator = require("../../../../../../common/constants/locator");
var _kibana = require("../../../../contexts/kibana");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../../../ml_nodes_check");
var _ml_empty_prompt_card = require("../../../../components/overview/ml_empty_prompt_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/anomaly_detection_empty_state/anomaly_detection_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AnomalyDetectionEmptyState = ({
  showDocsLink = false
}) => {
  const canCreateJob = (0, _check_capabilities.usePermissionCheck)('canCreateJob');
  const disableCreateAnomalyDetectionJob = !canCreateJob || !(0, _ml_nodes_check.mlNodesAvailable)();
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const mlLocator = (0, _kibana.useMlManagementLocator)();
  const redirectToCreateJobSelectIndexPage = async () => {
    if (!mlLocator) return;
    await mlLocator.navigate({
      sectionId: 'ml',
      appId: `anomaly_detection/${_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX}`
    });
  };
  return /*#__PURE__*/_react.default.createElement(_ml_empty_prompt_card.MLEmptyPromptCard, {
    layout: "horizontal",
    hasBorder: true,
    hasShadow: false,
    iconSrc: _anomaly_detection_kibana.default,
    iconAlt: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.title', {
      defaultMessage: 'Anomaly detection'
    }),
    title: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.createFirstJobMessage', {
      defaultMessage: 'Spot anomalies faster'
    }),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.emptyPromptText",
      defaultMessage: "Start automatically spotting anomalies hiding in your time series data and resolve issues faster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    })),
    actions: [...[/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: redirectToCreateJobSelectIndexPage,
      isDisabled: disableCreateAnomalyDetectionJob,
      "data-test-subj": "mlCreateNewJobButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.createJobButtonText",
      defaultMessage: "Create anomaly detection job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }))], ...(showDocsLink ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      href: docLinks.links.ml.anomalyDetection,
      "data-test-subj": "mlAnalyticsReadDocumentationButton",
      iconType: "popout",
      iconSide: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.common.readDocumentationLink",
      defaultMessage: "Read documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 17
      }
    }))] : [])],
    "data-test-subj": "mlAnomalyDetectionEmptyState",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.AnomalyDetectionEmptyState = AnomalyDetectionEmptyState;