"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMapComponentWrapper = EmbeddedMapComponentWrapper;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _map_config = require("./map_config");
var _kibana = require("../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/explorer_chart_embedded_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EmbeddedMapComponentWrapper({
  seriesConfig
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      maps: mapsPlugin
    }
  } = (0, _kibana.useMlKibana)();
  const [layerList, setLayerList] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (seriesConfig.mapData && seriesConfig.mapData.length > 0) {
      setLayerList([(0, _map_config.getMLAnomaliesActualLayer)(seriesConfig.mapData, euiTheme), (0, _map_config.getMLAnomaliesTypicalLayer)(seriesConfig.mapData)]);
    }
  }, [seriesConfig, euiTheme]);
  return mapsPlugin ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "xpack.ml.explorer.embeddedMap",
    style: {
      width: '100%',
      height: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(mapsPlugin.Map, {
    layerList: layerList,
    hideFilterActions: true,
    mapSettings: {
      initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
      autoFitToDataBounds: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })) : null;
}