"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluationQualityMetricsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/classification_exploration/evaluation_quality_metrics_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const columns = [{
  field: 'className',
  name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.recallAndAccuracyClassColumn', {
    defaultMessage: 'Class'
  }),
  sortable: true,
  truncateText: true
}, {
  field: 'accuracy',
  name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.recallAndAccuracyAccuracyColumn', {
    defaultMessage: 'Accuracy'
  }),
  render: value => Math.round(value * 1000) / 1000
}, {
  field: 'recall',
  name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.recallAndAccuracyRecallColumn', {
    defaultMessage: 'Recall'
  }),
  render: value => Math.round(value * 1000) / 1000
}];
const EvaluationQualityMetricsTable = ({
  evaluationMetricsItems
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  id: "recall-and-accuracy",
  buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionRecallAndAccuracy",
    defaultMessage: "Per class recall and accuracy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
  items: evaluationMetricsItems,
  columns: columns,
  pagination: true,
  sorting: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 9
  }
}))));
exports.EvaluationQualityMetricsTable = EvaluationQualityMetricsTable;