"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPageHeaderRenderer = exports.MlPageHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _eui = require("@elastic/eui");
var _ml_page = require("../ml_page/ml_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/page_header/page_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlPageHeader = ({
  children,
  leftSideItems,
  rightSideItems,
  restrictWidth,
  wrapHeader
}) => {
  const {
    headerPortal,
    leftHeaderPortal,
    rightHeaderPortal,
    setIsHeaderMounted,
    setIsLeftSectionMounted,
    setIsRightSectionMounted,
    setHeaderRestrictWidth,
    setWrapHeader
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  (0, _react.useEffect)(() => {
    setIsHeaderMounted(true);
    setIsLeftSectionMounted(!!leftSideItems);
    setIsRightSectionMounted(!!rightSideItems);
    setHeaderRestrictWidth(restrictWidth);
    setWrapHeader(!!wrapHeader);
    return () => {
      setIsHeaderMounted(false);
      setIsLeftSectionMounted(false);
      setIsRightSectionMounted(false);
      setHeaderRestrictWidth(undefined);
      setWrapHeader(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [leftSideItems, rightSideItems, restrictWidth, wrapHeader]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: headerPortal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, children), leftSideItems ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: leftHeaderPortal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 24
    }
  }, leftSideItems) : null, rightSideItems ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: rightHeaderPortal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 25
    }
  }, rightSideItems) : null);
};
exports.MlPageHeader = MlPageHeader;
const MlPageHeaderRenderer = () => {
  const {
    headerPortal,
    isHeaderMounted
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  return isHeaderMounted ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: headerPortal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 28
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 64
    }
  });
};
exports.MlPageHeaderRenderer = MlPageHeaderRenderer;