"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSelectionIdBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_selector_badge = require("../job_selector_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/new_selection_id_badges/new_selection_id_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NewSelectionIdBadges = ({
  limit,
  newSelection,
  onDeleteClick,
  onLinkClick,
  showAllBadges,
  groups
}) => {
  const badges = [];
  for (let i = 0; i < newSelection.length; i++) {
    if (i >= limit && showAllBadges === false) {
      break;
    }
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: newSelection[i],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
      id: newSelection[i],
      icon: true,
      isGroup: groups.some(g => g.id === newSelection[i]),
      removeId: onDeleteClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    })));
  }
  if (showAllBadges === false && newSelection.length > limit) {
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "more-badges-link",
      onClick: onLinkClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.jobSelector.showFlyoutBadges', {
      defaultMessage: `And {overFlow} more`,
      values: {
        overFlow: newSelection.length - limit
      }
    }))));
  } else if (showAllBadges === true && newSelection.length > limit) {
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "hide-badges-link",
      onClick: onLinkClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.jobSelector.hideFlyoutBadges', {
      defaultMessage: 'Hide'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
};
exports.NewSelectionIdBadges = NewSelectionIdBadges;