"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationDescriptionList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/annotations/annotation_description_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for listing pairs of information about the detector for which
 * rules are being edited.
 */
const AnnotationDescriptionList = ({
  annotation,
  detectorDescription
}) => {
  const listItems = [{
    title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.jobIdTitle', {
      defaultMessage: 'Job ID'
    }),
    description: annotation.job_id
  }, {
    title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.startTitle', {
      defaultMessage: 'Start'
    }),
    description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(annotation.timestamp)
  }];
  if (annotation.end_timestamp !== undefined) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.endTitle', {
        defaultMessage: 'End'
      }),
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(annotation.end_timestamp)
    });
  }
  if (annotation.create_time !== undefined && annotation.modified_time !== undefined) {
    var _annotation$create_us, _annotation$modified_;
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.createdTitle', {
        defaultMessage: 'Created'
      }),
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(annotation.create_time)
    });
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.createdByTitle', {
        defaultMessage: 'Created by'
      }),
      description: (_annotation$create_us = annotation.create_username) !== null && _annotation$create_us !== void 0 ? _annotation$create_us : ''
    });
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.lastModifiedTitle', {
        defaultMessage: 'Last modified'
      }),
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(annotation.modified_time)
    });
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.modifiedByTitle', {
        defaultMessage: 'Modified by'
      }),
      description: (_annotation$modified_ = annotation.modified_username) !== null && _annotation$modified_ !== void 0 ? _annotation$modified_ : ''
    });
  }
  if (detectorDescription !== undefined) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationDescriptionList.detectorTitle', {
        defaultMessage: 'Detector'
      }),
      description: detectorDescription
    });
  }
  if (annotation.partition_field_name !== undefined) {
    var _annotation$partition;
    listItems.push({
      title: annotation.partition_field_name,
      description: (_annotation$partition = annotation.partition_field_value) !== null && _annotation$partition !== void 0 ? _annotation$partition : ''
    });
  }
  if (annotation.over_field_name !== undefined) {
    var _annotation$over_fiel;
    listItems.push({
      title: annotation.over_field_name,
      description: (_annotation$over_fiel = annotation.over_field_value) !== null && _annotation$over_fiel !== void 0 ? _annotation$over_fiel : ''
    });
  }
  if (annotation.by_field_name !== undefined) {
    var _annotation$by_field_;
    listItems.push({
      title: annotation.by_field_name,
      description: (_annotation$by_field_ = annotation.by_field_value) !== null && _annotation$by_field_ !== void 0 ? _annotation$by_field_ : ''
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": 'mlAnnotationDescriptionList',
    type: "column",
    columnWidths: [3, 7],
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
};
exports.AnnotationDescriptionList = AnnotationDescriptionList;