"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppStateManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppStateManager {
  constructor() {
    (0, _defineProperty2.default)(this, "_query", null);
    (0, _defineProperty2.default)(this, "_savedQueryId", '');
    (0, _defineProperty2.default)(this, "_filters", []);
    (0, _defineProperty2.default)(this, "_updated$", new _rxjs.Subject());
  }
  setQueryAndFilters({
    query,
    savedQueryId,
    filters
  }) {
    if (query && this._query !== query) {
      this._query = query;
    }
    if (savedQueryId && this._savedQueryId !== savedQueryId) {
      this._savedQueryId = savedQueryId;
    }
    if (filters && this._filters !== filters) {
      this._filters = filters;
    }
    this._updated$.next();
  }
  getQuery() {
    return this._query;
  }
  getFilters() {
    return this._filters;
  }
  getAppState() {
    return {
      query: this._query,
      savedQueryId: this._savedQueryId,
      filters: this._filters
    };
  }
}
exports.AppStateManager = AppStateManager;