"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _metrics_editor = require("../../../../components/metrics_editor");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/metrics_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MetricsExpression extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_renderMetricsEditor", () => {
      if (!this.props.rightFields) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.maps.layerPanel.metricsExpression.joinMustBeSetErrorMessage",
          defaultMessage: "JOIN must be set",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 55,
            columnNumber: 11
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_metrics_editor.MetricsEditor, {
        fields: this.props.rightFields,
        metrics: this.props.metrics,
        onChange: this.props.onChange,
        allowMultipleMetrics: true,
        isJoin: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 7
        }
      });
    });
  }
  render() {
    const metricExpressions = this.props.metrics.filter(metric => {
      if (metric.type === _constants.AGG_TYPE.COUNT) {
        return true;
      }
      if (metric.field) {
        return true;
      }
      return false;
    }).map(metric => {
      // do not use metric label so field and aggregation are not obscured.
      if (metric.type === _constants.AGG_TYPE.COUNT) {
        return _constants.AGG_TYPE.COUNT;
      }
      return `${metric.type} ${metric.field}`;
    });
    const useMetricDescription = _i18n.i18n.translate('xpack.maps.layerPanel.metricsExpression.useMetricsDescription', {
      defaultMessage: '{metricsLength, plural, one {and use metric} other {and use metrics}}',
      values: {
        metricsLength: metricExpressions.length
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "metricsPopover",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      initialFocus: "body" /* avoid initialFocus on Combobox */,
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        onClick: this._togglePopover,
        description: useMetricDescription,
        uppercase: false,
        value: metricExpressions.length > 0 ? metricExpressions.join(', ') : _constants.AGG_TYPE.COUNT,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 11
        }
      }),
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 400
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.metricsExpression.metricsPopoverTitle",
      defaultMessage: "Configure join metrics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      className: "mapJoinExpressionHelpText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.metricsExpression.helpText",
      defaultMessage: "Metrics are added to layer features and used for data driven styling and tooltip content.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    })), this._renderMetricsEditor()));
  }
}
exports.MetricsExpression = MetricsExpression;