"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalFilterCheckbox = GlobalFilterCheckbox;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/global_filter_checkbox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GlobalFilterCheckbox({
  applyGlobalQuery,
  label,
  setApplyGlobalQuery,
  isFeatureEditorOpenForLayer
}) {
  const onApplyGlobalQueryChange = event => {
    setApplyGlobalQuery(event.target.checked);
  };
  const tooltipMessage = isFeatureEditorOpenForLayer ? _i18n.i18n.translate('xpack.maps.filterEditor.isGlobalSearchNotApplied', {
    defaultMessage: 'Global search is not applied to the layer while editing features'
  }) : _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalFilterHelp', {
    defaultMessage: 'When enabled, results narrowed by global search'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: label,
    checked: isFeatureEditorOpenForLayer ? false : applyGlobalQuery,
    onChange: onApplyGlobalQueryChange,
    "data-test-subj": "mapLayerPanelApplyGlobalQueryCheckbox",
    compressed: true,
    disabled: isFeatureEditorOpenForLayer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })));
}