"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoIndexPatternSelect = GeoIndexPatternSelect;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../kibana_services");
var _i18n_getters = require("../../common/i18n_getters");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/geo_index_pattern_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GeoIndexPatternSelect(props) {
  var _props$dataView;
  const [noDataViews, setNoDataViews] = (0, _react.useState)(false);
  const hasGeoFields = (0, _react.useMemo)(() => {
    return props.dataView ? props.dataView.fields.some(field => {
      return !_public.indexPatterns.isNestedField(field) && props !== null && props !== void 0 && props.isGeoPointsOnly ? _constants.ES_GEO_FIELD_TYPE.GEO_POINT === field.type : _constants.ES_GEO_FIELD_TYPES.includes(field.type);
    }) : false;
  }, [props.dataView, props === null || props === void 0 ? void 0 : props.isGeoPointsOnly]);
  const isMounted = (0, _useMountedState.default)();
  const dataViewIdRef = (0, _react.useRef)();
  async function _onIndexPatternSelect(indexPatternId) {
    if (!indexPatternId || indexPatternId.length === 0) {
      return;
    }
    dataViewIdRef.current = indexPatternId;
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
    } catch (err) {
      return;
    }

    // method may be called again before 'get' returns
    // ignore response when fetched index pattern does not match active index pattern
    if (isMounted() && indexPattern.id === dataViewIdRef.current) {
      props.onChange(indexPattern);
    }
  }
  function _renderNoIndexPatternWarning() {
    if (!noDataViews) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.maps.noIndexPattern.messageTitle', {
        defaultMessage: `Couldn't find any data views`
      }),
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisPrefixDescription",
      defaultMessage: "You'll need to ",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend(`/app/management/kibana/dataViews`),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisLinkTextDescription",
      defaultMessage: "Create a data view.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.hintDescription",
      defaultMessage: "Don't have any data? ",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend('/app/home#/tutorial_directory/sampleData'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.getStartedLinkText",
      defaultMessage: "Get started with some sample data sets.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }));
  }
  const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
  const isDataViewInvalid = !props.dataView ? false : !hasGeoFields;
  const error = isDataViewInvalid ? _i18n.i18n.translate('xpack.maps.noGeoFieldInIndexPattern.message', {
    defaultMessage: 'Data view does not contain any geospatial fields'
  }) : '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _renderNoIndexPatternWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _i18n_getters.getDataViewLabel)(),
    isInvalid: isDataViewInvalid,
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    isInvalid: isDataViewInvalid,
    isDisabled: noDataViews,
    indexPatternId: (_props$dataView = props.dataView) !== null && _props$dataView !== void 0 && _props$dataView.id ? props.dataView.id : '',
    onChange: _onIndexPatternSelect,
    placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
    onNoIndexPatterns: () => {
      setNoDataViews(true);
    },
    isClearable: false,
    "data-test-subj": "mapGeoIndexPatternSelect",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  })));
}