"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopHitsUpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _constants = require("../../../../../common/constants");
var _tooltip_selector = require("../../../../components/tooltip_selector");
var _kibana_services = require("../../../../kibana_services");
var _index_pattern_util = require("../../../../index_pattern_util");
var _es_doc_field = require("../../../fields/es_doc_field");
var _top_hits_form = require("./top_hits_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/top_hits/update_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TopHitsUpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false,
      isTimeseries: false,
      sourceFields: [],
      termFields: [],
      sortFields: []
    });
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesChange", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_onFilterByMapBoundsChange", event => {
      this.props.onChange({
        propName: 'filterByMapBounds',
        value: event.target.checked
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadFields() {
    this.setState({
      isLoading: true
    });
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          isLoading: false,
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(this.props.indexPatternId)
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }
    const rawTooltipFields = (0, _index_pattern_util.getSourceFields)(indexPattern.fields);
    const sourceFields = rawTooltipFields.map(field => {
      return new _es_doc_field.ESDocField({
        fieldName: field.name,
        source: this.props.source,
        origin: _constants.FIELD_ORIGIN.SOURCE
      });
    });
    this.setState({
      isLoading: false,
      isTimeseries: (0, _index_pattern_util.getIsTimeseries)(indexPattern),
      sourceFields,
      termFields: (0, _index_pattern_util.getTermsFields)(indexPattern.fields),
      sortFields: (0, _index_pattern_util.getSortFields)(indexPattern.fields)
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.tooltipsTitle",
      defaultMessage: "Tooltip fields",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      size: "s",
      isLoading: this.state.isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields,
      onChange: this._onTooltipPropertiesChange,
      fields: this.state.sourceFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.topHitsPanelLabel",
      defaultMessage: "Top hits",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      size: "s",
      isLoading: this.state.isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_top_hits_form.TopHitsForm, {
      indexPatternId: this.props.indexPatternId,
      isColumnCompressed: true,
      isTimeseries: this.state.isTimeseries,
      onChange: this.props.onChange,
      sortField: this.props.sortField,
      sortFields: this.state.sortFields,
      sortOrder: this.props.sortOrder,
      termFields: this.state.termFields,
      topHitsGroupByTimeseries: this.props.topHitsGroupByTimeseries,
      topHitsSplitField: this.props.topHitsSplitField,
      topHitsSize: this.props.topHitsSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.extentFilterLabel', {
        defaultMessage: 'Dynamically filter for data in the visible map area'
      }),
      checked: this.props.filterByMapBounds,
      onChange: this._onFilterByMapBoundsChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 9
      }
    }));
  }
}
exports.TopHitsUpdateSourceEditor = TopHitsUpdateSourceEditor;