"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultLayerDescriptor = createDefaultLayerDescriptor;
exports.esDocumentsLayerWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _create_source_editor = require("./create_source_editor");
var _es_search_source = require("./es_search_source");
var _vector_layer = require("../../layers/vector_layer");
var _constants = require("../../../../common/constants");
var _documents_layer_icon = require("../../layers/wizards/icons/documents_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/es_documents_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createDefaultLayerDescriptor(sourceConfig, mapColors) {
  const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor(sourceConfig);
  if (sourceDescriptor.scalingType === _constants.SCALING_TYPES.CLUSTERS) {
    return _vector_layer.BlendedVectorLayer.createDescriptor({
      sourceDescriptor
    }, mapColors);
  } else if (sourceDescriptor.scalingType === _constants.SCALING_TYPES.MVT) {
    return _vector_layer.MvtVectorLayer.createDescriptor({
      sourceDescriptor
    }, mapColors);
  } else {
    return _vector_layer.GeoJsonVectorLayer.createDescriptor({
      sourceDescriptor
    }, mapColors);
  }
}
const esDocumentsLayerWizardConfig = exports.esDocumentsLayerWizardConfig = {
  id: _constants.WIZARD_ID.ES_DOCUMENT,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.esSearchDescription', {
    defaultMessage: 'Points, lines, and polygons from Elasticsearch'
  }),
  icon: _documents_layer_icon.DocumentsLayerIcon,
  renderWizard: ({
    previewLayers,
    mapColors
  }) => {
    const onSourceConfigChange = (sourceConfig, isPointsOnly) => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const layerDescriptor = createDefaultLayerDescriptor(sourceConfig, mapColors);
      if (isPointsOnly) {
        layerDescriptor.style.properties[_constants.VECTOR_STYLES.LINE_WIDTH] = {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            size: 0
          }
        };
      }
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  },
  title: _es_search_source.sourceTitle
};