"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineCurveOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/expression-xy-plugin/public");
var _line_curve_definitions = require("./line_curve_definitions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/visual_options_popover/line_curve_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LineCurveOption = ({
  onChange,
  value = _public.XYCurveTypes.LINEAR,
  enabled = true
}) => {
  return enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineInterpolationLabel', {
      defaultMessage: 'Line interpolation'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "lnsCurveStyleSelect",
    compressed: true,
    options: _line_curve_definitions.lineCurveDefinitions.map(({
      type,
      title,
      description
    }) => ({
      value: type,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 15
        }
      }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 17
        }
      }, description))),
      inputDisplay: title
    })),
    valueOfSelected: value,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  })) : null;
};
exports.LineCurveOption = LineCurveOption;